/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util.json;

import dev.falsegamemaster.ihatecores.util.json.JsonElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class JsonFormat {
    public static final Consumer<JsonFormat> DEFAULT_FORMAT = format -> {
        format.internal.put(",", ",");
        format.internal.put(":", ":");
        format.internal.put("\t", "\t");
    };
    protected final Map<String, String> internal = new HashMap<String, String>();
    protected Predicate<JsonElement> shouldExpand = element -> false;
    protected Predicate<JsonElement> shouldCommaSpace = element -> false;
    protected Predicate<JsonElement> shouldColonSpace = element -> false;

    public JsonFormat() {
        this.setFormat(DEFAULT_FORMAT);
    }

    public JsonFormat setFormat(Consumer<JsonFormat> formatter) {
        formatter.accept(this);
        return this;
    }

    public String get(String key) {
        return this.internal.get(key);
    }

    public String get(String key, JsonElement element) {
        this.internal.put(",", this.shouldCommaSpace.test(element) ? ", " : ",");
        this.internal.put(":", this.shouldColonSpace.test(element) ? ": " : ":");
        return this.get(key);
    }

    public JsonFormat setExpanding() {
        this.shouldExpand = element -> true;
        return this;
    }

    public JsonFormat setExpandingIf(Predicate<JsonElement> shouldExpand) {
        this.shouldExpand = shouldExpand;
        return this;
    }

    public JsonFormat withCommaSpace() {
        this.shouldCommaSpace = element -> true;
        return this;
    }

    public JsonFormat withCommaSpaceIf(Predicate<JsonElement> shouldCommaSpace) {
        this.shouldCommaSpace = shouldCommaSpace;
        return this;
    }

    public JsonFormat withColonSpace() {
        this.shouldColonSpace = element -> true;
        return this;
    }

    public JsonFormat withColonSpaceIf(Predicate<JsonElement> shouldColonSpace) {
        this.shouldColonSpace = shouldColonSpace;
        return this;
    }

    public JsonFormat withTab() {
        this.internal.put("\t", "\t");
        return this;
    }

    public JsonFormat withTab(int spaces) {
        char[] tab = new char[spaces];
        Arrays.fill(tab, ' ');
        this.internal.put("\t", new String(tab));
        return this;
    }

    public boolean doesExpand(JsonElement element) {
        return this.shouldExpand.test(element);
    }

    public boolean hasCommaSpace(JsonElement element) {
        boolean b = this.shouldCommaSpace.test(element);
        if (b) {
            this.internal.put(",", ", ");
        }
        return b;
    }

    public boolean hasColonSpace(JsonElement element) {
        boolean b = this.shouldColonSpace.test(element);
        if (b) {
            this.internal.put(":", ": ");
        }
        return b;
    }

    public JsonFormat copy() {
        JsonFormat format = new JsonFormat();
        format.internal.putAll(this.internal);
        format.shouldExpand = this.shouldExpand;
        format.shouldCommaSpace = this.shouldCommaSpace;
        format.shouldColonSpace = this.shouldColonSpace;
        return format;
    }

    public JsonFormat copyFrom(JsonFormat other) {
        this.internal.putAll(other.internal);
        this.shouldExpand = other.shouldExpand;
        this.shouldCommaSpace = other.shouldCommaSpace;
        this.shouldColonSpace = other.shouldColonSpace;
        return this;
    }
}

