/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util.json;

import dev.falsegamemaster.ihatecores.util.json.CodeBuilder;
import dev.falsegamemaster.ihatecores.util.json.JsonCollection;
import dev.falsegamemaster.ihatecores.util.json.JsonFormat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public abstract class JsonElement {
    protected JsonCollection parent;
    protected String folderPath = null;
    protected String fileName = null;

    public JsonElement() {
        this.parent = null;
    }

    public JsonElement(JsonCollection parent) {
        this.parent = parent;
    }

    public Optional<JsonCollection> parent() {
        return Optional.ofNullable(this.parent);
    }

    public JsonElement setParent(JsonCollection parent) {
        this.parent = parent;
        return this;
    }

    public abstract void addTo(CodeBuilder var1);

    public String toString() {
        return new CodeBuilder(new JsonFormat().get("\t"), 0).toString();
    }

    public JsonElement setFolderPath(String path) {
        this.folderPath = path;
        return this;
    }

    public JsonElement setFileName(String name) {
        this.fileName = name;
        return this;
    }

    public JsonElement save() {
        return this.folderPath == null || this.fileName == null ? this : this.saveTo(this.folderPath + this.fileName + ".json");
    }

    public JsonElement saveTo(String path) {
        try {
            Path p = Paths.get(path, new String[0]).toAbsolutePath();
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.write(p, this.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }
}

