/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util.json;

import dev.falsegamemaster.ihatecores.util.json.CodeBuilder;
import dev.falsegamemaster.ihatecores.util.json.JsonCollection;
import dev.falsegamemaster.ihatecores.util.json.JsonElement;
import dev.falsegamemaster.ihatecores.util.json.JsonFormat;
import dev.falsegamemaster.ihatecores.util.json.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonArray
extends JsonCollection {
    protected List<JsonElement> elements = new ArrayList<JsonElement>();
    @Deprecated
    protected boolean isPrimitive = true;

    public List<JsonElement> elements() {
        return this.elements;
    }

    public JsonArray add(JsonElement element) {
        this.elements.add(element.setParent(this));
        this.isPrimitive = false;
        return this;
    }

    public <T extends Serializable> JsonArray add(T primitive) {
        return this.add(new JsonPrimitive<T>(primitive).setParent(this));
    }

    public JsonArray add(JsonElement ... elements) {
        for (JsonElement e : elements) {
            e.setParent(this);
        }
        this.elements.addAll(Arrays.asList(elements));
        this.isPrimitive = false;
        return this;
    }

    @SafeVarargs
    public final <T extends Serializable> JsonArray add(T ... primitives) {
        this.elements.addAll(Stream.of(primitives).map(p -> new JsonPrimitive<Serializable>((Serializable)p).setParent(this)).collect(Collectors.toList()));
        return this;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    @Override
    public void addTo(CodeBuilder builder) {
        JsonFormat format = new JsonFormat();
        this.formatter.accept(format, this);
        boolean expands = format.doesExpand(this);
        builder.add("[").newLineIf(expands, 1);
        Iterator iterator = this.elements().iterator();
        while (iterator.hasNext()) {
            JsonElement e = (JsonElement)iterator.next();
            if (e instanceof JsonCollection) {
                ((JsonCollection)e).setFormat(this.formatter);
            }
            e.addTo(builder);
            if (iterator.hasNext()) {
                builder.add(format.get(",", this)).newLineIf(expands, 0);
                continue;
            }
            builder.newLineIf(expands, -1);
        }
        builder.add("]");
    }
}

