/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util.json;

public class CodeBuilder {
    protected final String tab;
    protected int indents;
    protected final StringBuilder builder = new StringBuilder();

    public CodeBuilder(String tab, int indents) {
        this.tab = tab;
        this.indents = indents;
    }

    public String tab() {
        return this.tab;
    }

    public int indents() {
        return this.indents;
    }

    public String getIndent() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.indents; ++i) {
            builder.append(this.tab);
        }
        return builder.toString();
    }

    public CodeBuilder beginLine() {
        this.builder.append(this.getIndent());
        return this;
    }

    public CodeBuilder add(Object o) {
        this.builder.append(o);
        return this;
    }

    public CodeBuilder newLineNoIndent() {
        this.builder.append("\n");
        return this;
    }

    public CodeBuilder newLine(int i) {
        this.indents = Math.max(this.indents + i, 0);
        return this.newLineNoIndent().beginLine();
    }

    public CodeBuilder newLineIf(boolean condition, int i) {
        return condition ? this.newLine(i) : this;
    }

    public CodeBuilder indent(int i) {
        this.indents = Math.max(this.indents + i, 0);
        return this.beginLine();
    }

    public CodeBuilder indent() {
        ++this.indents;
        return this.beginLine();
    }

    public CodeBuilder outdent() {
        if (this.indents > 0) {
            --this.indents;
        }
        return this.beginLine();
    }

    public String toString() {
        return this.builder.toString();
    }
}

