/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util.algorithms;

import java.util.function.IntConsumer;

public class Loops {
    public static void ascending(int start, int count, IntConsumer consumer) {
        for (int i = start; i < start + Math.abs(count); ++i) {
            consumer.accept(i);
        }
    }

    public static void descending(int start, int count, IntConsumer consumer) {
        for (int i = start; i > start - Math.abs(count); --i) {
            consumer.accept(i);
        }
    }

    public static void ascendingReverse(int start, int count, IntConsumer consumer) {
        Loops.descending(start + count, count, consumer);
    }

    public static void descendingReverse(int start, int count, IntConsumer consumer) {
        Loops.ascending(start - count, count, consumer);
    }

    public static void bidiNoninclusive(int start, int count, IntConsumer consumer) {
        if (count < 0) {
            Loops.descending(start - 1, count, consumer);
        } else {
            Loops.ascending(start + 1, count, consumer);
        }
    }

    @Deprecated
    public static void bidiNoninclusiveReverse(int start, int count, IntConsumer consumer) {
        if (count < 0) {
            Loops.ascending(start + 1, count, consumer);
        } else {
            Loops.descending(start - 1, count, consumer);
        }
    }

    public static void bidiNoninclusiveAscending(int start, int count, IntConsumer consumer) {
        if (count < 0) {
            Loops.descendingReverse(start - 1, count, consumer);
        } else {
            Loops.ascending(start + 1, count, consumer);
        }
    }

    public static void bidiNoninclusiveDescending(int start, int count, IntConsumer consumer) {
        if (count < 0) {
            Loops.descending(start - 1, count, consumer);
        } else {
            Loops.ascendingReverse(start + 1, count, consumer);
        }
    }

    public static void bidiInclusive(int start, int count, IntConsumer consumer) {
        consumer.accept(start);
        Loops.bidiNoninclusive(start, count, consumer);
    }

    @Deprecated
    public static void bidiInclusiveReverse(int start, int count, IntConsumer consumer) {
        consumer.accept(start);
        Loops.bidiNoninclusiveReverse(start, count, consumer);
    }

    public static void bidiInclusiveAscending(int start, int count, IntConsumer consumer) {
        consumer.accept(start);
        Loops.bidiNoninclusiveAscending(start, count, consumer);
    }

    public static void bidiInclusiveDescending(int start, int count, IntConsumer consumer) {
        consumer.accept(start);
        Loops.bidiNoninclusiveDescending(start, count, consumer);
    }
}

