/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util;

import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class TypePreservingMap<K, V> {
    protected final Map<K, V> internal;

    public TypePreservingMap(Supplier<Map<K, V>> map) {
        this.internal = map.get();
    }

    public TypePreservingMap() {
        this(LinkedHashMap::new);
    }

    public int size() {
        return this.internal.size();
    }

    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.internal.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.internal.containsValue(value);
    }

    public <W extends V> W get(K key) {
        return (W)GenericsUtil.castOrNull(this.internal.get(key));
    }

    public V put(K key, V value) {
        return this.internal.put(key, value);
    }

    public <W extends V> W remove(K key) {
        return (W)GenericsUtil.castOrNull(this.internal.remove(key));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.internal.putAll(m);
    }

    public void clear() {
        this.internal.clear();
    }

    public Map<K, V> get(Function<Map<K, V>, Map<K, V>> copier) {
        return copier.apply(this.internal);
    }

    public Map<K, V> get() {
        return this.get(LinkedHashMap::new);
    }

    public Set<K> keySet() {
        return this.internal.keySet();
    }

    public Collection<V> values() {
        return this.internal.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.internal.entrySet();
    }

    public <W extends V> W getOrDefault(K key, W defaultValue) {
        W w = this.get(key);
        return w != null || this.containsKey(key) ? w : defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.internal.forEach(action);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.internal.replaceAll(function);
    }

    public <W extends V> W putIfAbsent(K key, W value) {
        this.internal.putIfAbsent(key, value);
        return value;
    }

    public boolean remove(K key, V value) {
        return this.internal.remove(key, value);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.internal.replace(key, oldValue, newValue);
    }

    public V replace(K key, V value) {
        return this.internal.replace(key, value);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.internal.computeIfAbsent((K)key, mappingFunction);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.internal.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.internal.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.internal.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

