/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.util;

import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.SafeBlockState;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;

public class BlockStateUtil {
    public static <V extends Comparable<V>> Optional<V> tryGetValue(BlockState state, Property<V> property) {
        if (!state.func_235901_b_(property)) {
            return Optional.empty();
        }
        return Optional.of(state.func_177229_b(property));
    }

    public static <V extends Comparable<V>> BlockState trySetValue(BlockState state, Property<V> property, V value) {
        if (!state.func_235901_b_(property)) {
            return state;
        }
        return (BlockState)state.func_206870_a(property, value);
    }

    public static <V extends Comparable<V>> BlockState copyProperties(BlockState from, BlockState to) {
        Stream<Property> properties = from.func_235904_r_().stream().map(GenericsUtil::castOrNull);
        for (Property property : properties.collect(Collectors.toList())) {
            to = BlockStateUtil.trySetValue(to, property, from.func_177229_b(property));
        }
        return to;
    }

    public static List<Direction> getDirections(BlockState state) {
        SafeBlockState safeState = SafeBlockState.of(state);
        ArrayList<Direction> directions = new ArrayList<Direction>();
        if (safeState.getValue(BlockStateProperties.field_208151_D).orElse(false).booleanValue()) {
            directions.add(Direction.NORTH);
        }
        if (safeState.getValue(BlockStateProperties.field_208152_E).orElse(false).booleanValue()) {
            directions.add(Direction.EAST);
        }
        if (safeState.getValue(BlockStateProperties.field_208153_F).orElse(false).booleanValue()) {
            directions.add(Direction.SOUTH);
        }
        if (safeState.getValue(BlockStateProperties.field_208154_G).orElse(false).booleanValue()) {
            directions.add(Direction.WEST);
        }
        if (safeState.getValue(BlockStateProperties.field_208149_B).orElse(false).booleanValue()) {
            directions.add(Direction.UP);
        }
        if (safeState.getValue(BlockStateProperties.field_208150_C).orElse(false).booleanValue()) {
            directions.add(Direction.DOWN);
        }
        return directions;
    }

    public static BlockState setDirection(BlockState state, Direction direction) {
        SafeBlockState safeState = SafeBlockState.of(state);
        switch (direction) {
            case NORTH: {
                return safeState.setValue(BlockStateProperties.field_208151_D, true).get();
            }
            case EAST: {
                return safeState.setValue(BlockStateProperties.field_208152_E, true).get();
            }
            case SOUTH: {
                return safeState.setValue(BlockStateProperties.field_208153_F, true).get();
            }
            case WEST: {
                return safeState.setValue(BlockStateProperties.field_208154_G, true).get();
            }
            case UP: {
                return safeState.setValue(BlockStateProperties.field_208149_B, true).get();
            }
            case DOWN: {
                return safeState.setValue(BlockStateProperties.field_208150_C, true).get();
            }
        }
        return state;
    }
}

