/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.falsegamemaster.ihatecores.util.nbt.FormattedCompoundNBT;
import dev.falsegamemaster.ihatecores.util.nbt.NbtTypes;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class RecipeUtil {
    public static Ingredient ingredientFromNbt(CompoundNBT nbt) {
        return Ingredient.func_199802_a((JsonElement)RecipeUtil.jsonObjectFromNbt(nbt));
    }

    public static CompoundNBT ingredientToNbt(Ingredient ingredient) {
        CompoundNBT nbt = new CompoundNBT();
        ItemStack[] items = ingredient.func_193365_a();
        nbt.func_74768_a("size", items.length);
        ListNBT list = new ListNBT();
        for (ItemStack item : items) {
            list.add((Object)item.serializeNBT());
        }
        nbt.func_218657_a("items", (INBT)list);
        return nbt;
    }

    public static NonNullList<Ingredient> ingredientsFromNbt(ListNBT list) {
        return list.stream().map(a -> RecipeUtil.ingredientFromNbt((CompoundNBT)a)).collect(NonNullList::func_191196_a, List::add, List::addAll);
    }

    public static ListNBT ingredientsToNbt(NonNullList<Ingredient> ingredients) {
        return ingredients.stream().map(RecipeUtil::ingredientToNbt).collect(ListNBT::new, AbstractList::add, AbstractCollection::addAll);
    }

    public static Ingredient ingredientFromNbt2(CompoundNBT nbt) {
        ItemStack stack = RecipeUtil.itemFromNbt(nbt);
        stack.func_190920_e(1);
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
    }

    public static NonNullList<Ingredient> ingredientsFromNbt2(ListNBT list) {
        return list.stream().map(a -> RecipeUtil.ingredientFromNbt2((CompoundNBT)a)).collect(NonNullList::func_191196_a, List::add, List::addAll);
    }

    public static Item getItemFromRegistry(String item) {
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(item));
    }

    public static ItemStack itemFromNbt(CompoundNBT nbt) {
        FormattedCompoundNBT formatted = FormattedCompoundNBT.format(nbt, s -> s.toLowerCase().replace("_", ""));
        Item item = RecipeUtil.getItemFromRegistry(formatted.func_74779_i("item"));
        int count = formatted.func_150297_b("count", NbtTypes.INT.get()) ? formatted.func_74762_e("count") : 1;
        ItemStack stack = new ItemStack((IItemProvider)item, count);
        if (formatted.func_150297_b("data", NbtTypes.COMPOUND.get())) {
            stack.func_77982_d(formatted.func_74775_l("data"));
        }
        return stack;
    }

    public static NonNullList<ItemStack> itemsFromNbt(ListNBT list) {
        return list.stream().map(i -> RecipeUtil.itemFromNbt((CompoundNBT)i)).collect(NonNullList::func_191196_a, List::add, List::addAll);
    }

    public static ListNBT ingredientsFromJson(JsonArray array) {
        ListNBT list = new ListNBT();
        array.forEach(e -> list.add((Object)RecipeUtil.ingredientToNbt(Ingredient.func_199802_a((JsonElement)e))));
        return list;
    }

    public static ListNBT itemsFromJson(JsonArray array) {
        ListNBT list = new ListNBT();
        array.forEach(e -> list.add((Object)ShapedRecipe.func_199798_a((JsonObject)e.getAsJsonObject()).serializeNBT()));
        return list;
    }

    public static CompoundNBT nbtFromJson(JsonObject json) {
        CompoundNBT nbt = new CompoundNBT();
        try {
            nbt = JsonToNBT.func_180713_a((String)json.toString());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return nbt;
    }

    public static JsonElement jsonElementFromNbt(INBT nbt) {
        if (nbt instanceof NumberNBT) {
            return new JsonPrimitive(((NumberNBT)nbt).func_209908_j());
        }
        if (nbt instanceof StringNBT) {
            return new JsonPrimitive(nbt.func_150285_a_());
        }
        if (nbt instanceof ListNBT) {
            return RecipeUtil.jsonArrayFromNbt((ListNBT)nbt);
        }
        if (nbt instanceof CompoundNBT) {
            return RecipeUtil.jsonObjectFromNbt((CompoundNBT)nbt);
        }
        return null;
    }

    public static JsonArray jsonArrayFromNbt(ListNBT list) {
        return list.stream().map(RecipeUtil::jsonElementFromNbt).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }

    public static JsonObject jsonObjectFromNbt(CompoundNBT nbt) {
        JsonObject json = new JsonObject();
        nbt.func_150296_c().forEach(key -> json.add(key, RecipeUtil.jsonElementFromNbt(nbt.func_74781_a(key))));
        return json;
    }
}

