/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.recipes;

import com.google.gson.JsonObject;
import dev.falsegamemaster.ihatecores.registration.block_entities.IRecipeInventory;
import dev.falsegamemaster.ihatecores.registration.recipes.INbtRecipe;
import dev.falsegamemaster.ihatecores.registration.recipes.IngredientData;
import dev.falsegamemaster.ihatecores.registration.recipes.RecipeSerializer;
import dev.falsegamemaster.ihatecores.registration.recipes.RecipeUtil;
import dev.falsegamemaster.ihatecores.util.nbt.NbtTypes;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class Recipe<I extends IInventory & IRecipeInventory<? extends Container, ? extends Recipe<I>>>
implements INbtRecipe<I> {
    protected final IRecipeSerializer<?> serializer;
    protected CompoundNBT nbt;

    public Recipe(IRecipeSerializer<?> serializer, CompoundNBT nbt) {
        this.serializer = serializer;
        this.nbt = nbt;
        if (nbt.func_74767_n("validate")) {
            this.validateNbt();
        }
    }

    @Override
    public CompoundNBT getData() {
        return this.nbt;
    }

    public boolean isValidNbt() {
        return !this.nbt.isEmpty() && !this.nbt.func_74779_i("type").equals("") && !this.nbt.func_74779_i("id").equals("") && !this.nbt.func_74775_l("result").isEmpty();
    }

    public void validateNbt() {
        if (!this.isValidNbt()) {
            throw new IllegalStateException("Invalid Recipe NBT");
        }
    }

    public ResourceLocation func_199560_c() {
        return new ResourceLocation(this.nbt.func_74779_i("id"));
    }

    public IRecipeType<?> func_222127_g() {
        IRecipeType type = (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation(this.nbt.func_74779_i("type")));
        assert (type != null);
        return type;
    }

    public NonNullList<Ingredient> func_192400_c() {
        ListNBT list = this.nbt.func_150295_c("ingredients", NbtTypes.COMPOUND.get());
        return IngredientData.getIngredientsFromNbt(list);
    }

    public ItemStack func_77571_b() {
        return ItemStack.func_199557_a((CompoundNBT)this.nbt.func_74775_l("result"));
    }

    protected <R extends IRecipe<?>> R getRecipe() {
        return (R)this;
    }

    @Deprecated
    public boolean func_77569_a(I inventory, @Nonnull World world) {
        return ((IRecipeInventory)inventory).matchesRecipe(this.getRecipe());
    }

    @Deprecated
    public ItemStack func_77572_b(I inventory) {
        return ((IRecipeInventory)inventory).assembleRecipe(this.getRecipe());
    }

    public boolean func_194133_a(int x, int y) {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public static class Serializer<I extends IInventory & IRecipeInventory<? extends Container, ? extends Recipe<I>>>
    extends RecipeSerializer<Recipe<I>> {
        protected final Function<CompoundNBT, Recipe<I>> recipeFromNbt = nbt -> (Recipe)recipeFromNbt.apply(this, (CompoundNBT)nbt);

        public Serializer(BiFunction<IRecipeSerializer<?>, CompoundNBT, Recipe<I>> recipeFromNbt) {
        }

        @Override
        public Recipe<I> recipeFromJson(ResourceLocation id, JsonObject json) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_197643_a(RecipeUtil.nbtFromJson(json));
            nbt.func_74778_a("id", id.toString());
            if (!nbt.func_74764_b("result")) {
                nbt.func_218657_a("result", (INBT)ItemStack.field_190927_a.serializeNBT());
            }
            nbt.func_74757_a("validate", true);
            return this.recipeFromNbt.apply(nbt);
        }

        @Override
        public Recipe<I> recipeFromNetwork(ResourceLocation id, PacketBuffer buffer) {
            CompoundNBT nbt = buffer.func_150793_b();
            assert (nbt != null);
            nbt.func_74778_a("id", id.toString());
            return this.recipeFromNbt.apply(nbt);
        }

        @Override
        public void recipeToNetwork(PacketBuffer buffer, Recipe<I> recipe) {
            buffer.func_150786_a(recipe.nbt);
        }
    }
}

