/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.recipes;

import dev.falsegamemaster.ihatecores.registration.recipes.IngredientData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.Validate;

public class IngredientList<I extends Ingredient>
extends NonNullList<I> {
    public IngredientList() {
    }

    public IngredientList(List<I> list, @Nullable I fallback) {
        super(list, fallback);
    }

    @Nonnull
    public I get(int index) {
        if (0 <= index && index < this.size()) {
            return (I)((Ingredient)super.get(index));
        }
        return (I)((Object)IngredientData.empty().toIngredient());
    }

    public IngredientList<I> resize(int size, IntFunction<I> valueFunction, I defaultValue) {
        Validate.notNull(defaultValue);
        ArrayList<I> resized = new ArrayList<I>();
        for (int i = 0; i < size; ++i) {
            resized.add(valueFunction.apply(i));
        }
        return new IngredientList(resized, defaultValue);
    }

    public IngredientList<I> matchSize(int size, I fallback) {
        return this.resize(size, i -> i < this.size() ? this.get(i) : fallback, fallback);
    }
}

