/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.recipes;

import dev.falsegamemaster.ihatecores.registration.recipes.CraftingResult;
import dev.falsegamemaster.ihatecores.registration.recipes.CustomIngredient;
import dev.falsegamemaster.ihatecores.registration.recipes.IngredientList;
import dev.falsegamemaster.ihatecores.util.nbt.FormattedCompoundNBT;
import dev.falsegamemaster.ihatecores.util.nbt.NbtTypes;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class IngredientData {
    protected final ITag<Item> items;
    protected final int count;
    protected final int minimumDurability;
    protected final CompoundNBT data;
    protected final boolean persistent;
    protected final boolean takeRemainder;
    protected final ItemStack remainder;
    protected final Function<ItemStack, Integer> damage;

    public static List<IngredientData> getDataFromNbt(ListNBT list) {
        return list.stream().map(i -> IngredientData.getDataFromNbt((CompoundNBT)i)).collect(Collectors.toList());
    }

    public static IngredientData getDataFromNbt(CompoundNBT nbt) {
        nbt = FormattedCompoundNBT.format(nbt, IngredientData::formatNbtKey);
        ITag<Item> items = IngredientData.getItems(nbt);
        int count = IngredientData.getCountFromNbt(nbt);
        CompoundNBT data = nbt.func_74775_l("data");
        IngredientData.setupData(nbt, data);
        return new IngredientData(items, count, data);
    }

    public static IngredientList<Ingredient> getIngredientsFromNbt(ListNBT list) {
        return list.stream().map(i -> IngredientData.getIngredientFromNbt((CompoundNBT)i)).collect(IngredientList::new, AbstractList::add, AbstractCollection::addAll);
    }

    public static CustomIngredient getIngredientFromNbt(CompoundNBT nbt) {
        return IngredientData.getDataFromNbt(nbt).toIngredient();
    }

    public static IngredientData empty() {
        HashSet<Item> items = new HashSet<Item>();
        items.add(Items.field_190931_a);
        return new IngredientData((ITag<Item>)ITag.func_232946_a_(items), 1, new CompoundNBT());
    }

    protected static void setupData(CompoundNBT nbt, CompoundNBT data) {
        IngredientData.putIfPresent("craftingDamage", nbt, data);
        IngredientData.putIfPresent("persistent", nbt, data);
        IngredientData.putIfPresent("minimumDurability", nbt, data);
        IngredientData.putIfPresent("remainder", nbt, data);
        IngredientData.putIfPresent("takeRemainder", nbt, data);
    }

    protected static void putIfPresent(String key, CompoundNBT nbt, CompoundNBT data) {
        INBT value;
        if (nbt.func_74764_b(key) && (value = nbt.func_74781_a(key)) != null) {
            data.func_218657_a(key, value);
        }
    }

    protected static int getCountFromNbt(CompoundNBT nbt) {
        return nbt.func_150297_b("count", NbtTypes.INT.get()) ? nbt.func_74762_e("count") : 1;
    }

    protected static Function<ItemStack, Integer> getDamageFromNbt(INBT craftingDamage) {
        return stack -> {
            int i = stack.func_77952_i();
            if (craftingDamage instanceof NumberNBT) {
                i += ((NumberNBT)craftingDamage).func_150287_d();
            } else if (craftingDamage instanceof StringNBT) {
                String s = craftingDamage.func_150285_a_();
                if (s.startsWith("+")) {
                    i += Integer.parseInt(s.substring(1));
                } else if (s.startsWith("-")) {
                    i -= Integer.parseInt(s.substring(1));
                }
            }
            return i;
        };
    }

    protected static Item getItemFromRegistry(String registryName) {
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(registryName));
    }

    protected static ITag<Item> getItems(CompoundNBT nbt) {
        if (nbt.func_150297_b("item", NbtTypes.STRING.get()) && nbt.func_150297_b("tag", NbtTypes.STRING.get())) {
            throw new IllegalStateException("Recipe ingredient cannot contain \"item\" and \"tag\"");
        }
        if (nbt.func_150297_b("item", NbtTypes.STRING.get())) {
            HashSet<Item> itemSet = new HashSet<Item>();
            itemSet.add(IngredientData.getItemFromRegistry(nbt.func_74779_i("item")));
            return ITag.func_232946_a_(itemSet);
        }
        if (nbt.func_150297_b("tag", NbtTypes.STRING.get())) {
            return ItemTags.func_199903_a().func_241834_b(new ResourceLocation(nbt.func_74779_i("tag")));
        }
        return ITag.func_232946_a_(new HashSet());
    }

    protected static String formatNbtKey(String key) {
        return key.toLowerCase().replace("_", "");
    }

    protected static CompoundNBT remapItemDataKeys(ItemStack stack, CompoundNBT data) {
        if (data.func_150297_b("durability", NbtTypes.INT.get())) {
            data.func_74768_a("damage", stack.func_77958_k() - data.func_74762_e("durability"));
            data.func_82580_o("durability");
        }
        return data;
    }

    public static ItemStack getRemainderFromNbt(CompoundNBT remainder) {
        if (remainder.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Item item = IngredientData.getItemFromRegistry(remainder.func_74779_i("item"));
        int count = IngredientData.getCountFromNbt(remainder);
        ItemStack stack = new ItemStack((IItemProvider)item, count);
        stack.func_77982_d(IngredientData.remapItemDataKeys(stack, remainder.func_74775_l("data")));
        return stack;
    }

    public static IngredientList<CustomIngredient> filterIngredients(List<Ingredient> ingredients) {
        return ingredients.stream().filter(i -> i instanceof CustomIngredient).map(i -> (CustomIngredient)((Object)i)).collect(IngredientList::new, AbstractList::add, AbstractCollection::addAll);
    }

    public IngredientData(ITag<Item> items, int count, CompoundNBT data) {
        this.items = items;
        this.count = count;
        this.data = data;
        this.persistent = data.func_74767_n("persistent");
        this.remainder = IngredientData.getRemainderFromNbt(data.func_74775_l("remainder"));
        this.damage = IngredientData.getDamageFromNbt(data.func_74781_a("craftingDamage"));
        this.minimumDurability = data.func_74762_e("minimumDurability");
        this.takeRemainder = data.func_74767_n("takeRemainder");
    }

    public boolean test(ItemStack stack) {
        int count = stack.func_190926_b() ? 1 : stack.func_190916_E();
        boolean hasItem = this.items.func_230235_a_((Object)stack.func_77973_b());
        boolean enoughCount = this.count <= count;
        boolean enoughDurability = this.minimumDurability <= stack.func_77958_k() - stack.func_77952_i();
        return hasItem && enoughCount && enoughDurability;
    }

    protected static CraftingResult.RemainderInfo remainderInfo(@Nullable ItemStack inventoryRemainder, @Nullable ItemStack playerRemainder) {
        return new CraftingResult.RemainderInfo(inventoryRemainder, playerRemainder);
    }

    public CraftingResult.RemainderInfo craft(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        if (this.persistent && copy.func_77984_f()) {
            int damage = this.damage.apply(copy);
            if (damage > copy.func_77958_k()) {
                return IngredientData.remainderInfo(this.remainder, null);
            }
            copy.func_196085_b(damage);
        } else if (!this.persistent) {
            copy.func_190918_g(this.count);
            return !this.takeRemainder && copy.func_190926_b() ? IngredientData.remainderInfo(this.remainder, null) : IngredientData.remainderInfo(copy, this.remainder);
        }
        return IngredientData.remainderInfo(copy, null);
    }

    public CustomIngredient toIngredient() {
        return new CustomIngredient(this.items, this);
    }
}

