/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.recipes;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CraftingResult {
    protected final boolean success;
    protected final List<RemainderInfo> remainders;

    public static CraftingResult success(List<RemainderInfo> remainders) {
        return new CraftingResult(true, remainders);
    }

    public static CraftingResult failure() {
        return new CraftingResult(false, null);
    }

    protected CraftingResult(boolean success, List<RemainderInfo> remainders) {
        this.success = success;
        this.remainders = remainders;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Optional<List<RemainderInfo>> getRemainders() {
        return Optional.ofNullable(this.remainders);
    }

    public static class RemainderInfo {
        protected final ItemStack inventoryRemainder;
        protected final ItemStack playerRemainder;

        public RemainderInfo(@Nullable ItemStack inventoryRemainder, @Nullable ItemStack playerRemainder) {
            this.inventoryRemainder = inventoryRemainder;
            this.playerRemainder = playerRemainder;
        }

        public Optional<ItemStack> getInventoryRemainder() {
            return Optional.ofNullable(this.inventoryRemainder);
        }

        public Optional<ItemStack> getPlayerRemainder() {
            return Optional.ofNullable(this.playerRemainder);
        }
    }
}

