/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.packets;

import dev.falsegamemaster.ihatecores.api.RegistryMap;
import dev.falsegamemaster.ihatecores.registration.events.StartupEventHandler;
import dev.falsegamemaster.ihatecores.registration.packets.NbtPacket;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketMap
extends RegistryMap<NbtPacket>
implements StartupEventHandler {
    protected static final Map<String, SimpleChannel> CHANNELS = new HashMap<String, SimpleChannel>();
    protected final String version = "1.0";
    protected SimpleChannel channel = null;
    protected final List<Consumer<SimpleChannel>> queue = new ArrayList<Consumer<SimpleChannel>>();

    public PacketMap() {
        super(NbtPacket.class);
    }

    public SimpleChannel getChannel() {
        return this.channel;
    }

    protected void tryCreateChannel(String modid) {
        ResourceLocation loc = new ResourceLocation(modid, "network");
        try {
            if (CHANNELS.containsKey(loc.toString())) {
                this.channel = CHANNELS.get(loc.toString());
            } else {
                this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)loc, () -> "1.0", v -> v.equals("1.0"), v -> v.equals("1.0"));
                CHANNELS.put(loc.toString(), this.channel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setModId(@Nonnull String modid) {
        super.setModId(modid);
        this.tryCreateChannel(modid);
    }

    protected <P extends NbtPacket> void registerPacket(SimpleChannel channel, P packet, int index) {
        Class clazz = (Class)GenericsUtil.castOrNull(packet.getClass());
        channel.registerMessage(index, clazz, NbtPacket::encode, buffer -> {
            packet.decode((PacketBuffer)buffer);
            return packet;
        }, NbtPacket::handle);
    }

    @Override
    public NbtPacket put(String name, NbtPacket packet) {
        this.queue.add(channel -> this.registerPacket((SimpleChannel)channel, (NbtPacket)packet, this.queue.size()));
        return super.put(name, packet);
    }

    @Override
    public NbtPacket put(String name, Function<CompoundNBT, NbtPacket> packet) {
        return this.put(name, packet.apply(new CompoundNBT()));
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent e) {
        if (this.channel != null) {
            this.queue.forEach((? super T queued) -> queued.accept(this.channel));
        }
    }
}

