/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.items;

import dev.falsegamemaster.ihatecores.api.ForgeRegistryMap;
import dev.falsegamemaster.ihatecores.registration.blocks.IBlockColorWrapper;
import dev.falsegamemaster.ihatecores.registration.events.ColorRegistry;
import dev.falsegamemaster.ihatecores.registration.items.IDynamicColorItem;
import dev.falsegamemaster.ihatecores.registration.items.IItemColorWrapper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="keys_and_leds_core", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ItemMap
extends ForgeRegistryMap<Item> {
    protected final ColorRegistry colorRegistry;

    public ItemMap(ColorRegistry colorRegistry) {
        super(Item.class);
        this.colorRegistry = colorRegistry;
    }

    public ItemMap() {
        this(new ColorRegistry());
    }

    public Item put(String name, Item item, IItemColorWrapper color) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.colorRegistry.register((IItemProvider)item, color));
        return super.put(name, item);
    }

    public Item put(String name, BlockItem item, IBlockColorWrapper color) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.colorRegistry.register(item.func_179223_d(), color));
        return (Item)super.put(name, item);
    }

    @Override
    public Item put(String name, Item item) {
        if (!(item instanceof IDynamicColorItem)) {
            return super.put(name, item);
        }
        IDynamicColorItem colorItem = (IDynamicColorItem)item;
        return this.put(name, item, colorItem::getColor);
    }

    @SubscribeEvent
    public void registerColors(ColorHandlerEvent.Item event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.colorRegistry.register(event));
    }
}

