/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features.configs;

import dev.falsegamemaster.ihatecores.registration.features.IStructurePredicate;
import dev.falsegamemaster.ihatecores.registration.features.configs.ISchematicFeatureConfig;
import dev.falsegamemaster.ihatecores.registration.features.configurators.ISchematicConfigurator;
import dev.falsegamemaster.ihatecores.registration.features.decorators.ISchematicDecorator;
import dev.falsegamemaster.ihatecores.registration.features.positioners.ISchematicPositioner;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public abstract class SchematicFeatureConfig<FC extends ISchematicFeatureConfig<FC>>
implements ISchematicFeatureConfig<FC> {
    protected final FC instance = (ISchematicFeatureConfig)GenericsUtil.castOrNull(this);
    protected final List<ResourceLocation> schematics;
    protected List<PlacementSettings> settings = new ArrayList<PlacementSettings>();
    protected ISchematicConfigurator configurator = ISchematicConfigurator.none();
    protected ISchematicDecorator decorator = ISchematicDecorator.none();
    protected ISchematicPositioner positioner = ISchematicPositioner.none();

    public SchematicFeatureConfig(List<ResourceLocation> schematics) {
        this.schematics = schematics;
        for (int i = 0; i < this.schematics.size(); ++i) {
            this.settings.add(new PlacementSettings().func_215222_a(IStructurePredicate.IGNORE_AIR.get()));
        }
    }

    public SchematicFeatureConfig(String modid, String ... schematics) {
        this(Stream.of(schematics).map(s -> new ResourceLocation(modid, s)).collect(Collectors.toList()));
    }

    @Override
    public List<ResourceLocation> getSchematics() {
        return this.schematics;
    }

    @Override
    public List<PlacementSettings> getPlacementSettings(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos original, BlockPos.Mutable mutable, List<Template> templates, CompoundNBT nbt) {
        return this.settings;
    }

    @Override
    public FC setPlacementSettings(List<PlacementSettings> settings) {
        this.settings = settings;
        return this.instance;
    }

    @Override
    public FC setConfigurator(ISchematicConfigurator configurator) {
        this.configurator = configurator;
        return this.instance;
    }

    @Override
    public FC setDecorator(ISchematicDecorator modifier) {
        this.decorator = modifier;
        return this.instance;
    }

    @Override
    public FC setPositioner(ISchematicPositioner positioner) {
        this.positioner = positioner;
        return this.instance;
    }

    @Override
    public boolean configureSchematics(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos original, BlockPos.Mutable mutable, List<Template> templates, List<PlacementSettings> placementSettings, CompoundNBT nbt) {
        return this.configurator.configureSchematics(reader, generator, random, original, mutable, templates, placementSettings, nbt);
    }

    @Override
    public boolean decorateSchematics(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos pos, List<Template> templates, CompoundNBT nbt) {
        return this.decorator.decorateSchematics(reader, generator, random, pos, templates, nbt);
    }

    @Override
    public Stream<BlockPos> getPositionsInChunk(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos chunkPos, List<Template> templates) {
        return this.positioner.getPositionsInChunk(reader, generator, random, chunkPos, templates);
    }
}

