/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features.configs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;

public interface IFullFeatureConfig
extends IFeatureConfig,
IPlacementConfig {
    public List<ResourceLocation> allowedBiomes();

    public List<ResourceLocation> ignoredBiomes();

    public int minAmountPerChunk();

    public int maxAmountPerChunk();

    public double averageAmountPerChunk();

    public int spawnAttempts();

    default public int amountInChunk(Random random) {
        int min = this.minAmountPerChunk();
        int max = this.maxAmountPerChunk();
        double average = this.averageAmountPerChunk();
        if (min > max) {
            int minOld = min;
            min = max;
            max = minOld;
        }
        int quantity = min;
        int range = max - min;
        if (range == 0 || average < (double)min || average > (double)max) {
            return -1;
        }
        for (int i = 0; i < range; ++i) {
            if (!((double)random.nextFloat() < (average - (double)min) / (double)range)) continue;
            ++quantity;
        }
        return quantity;
    }

    public static class BiomeConfig {
        protected final List<ResourceLocation> allowedBiomes = new ArrayList<ResourceLocation>();
        protected final List<ResourceLocation> ignoredBiomes = new ArrayList<ResourceLocation>();
        private boolean biomeListsLocked = false;

        public BiomeConfig allowedBiomes(ResourceLocation ... biomes) {
            if (this.biomeListsLocked) {
                return this;
            }
            this.allowedBiomes.addAll(Arrays.asList(biomes));
            this.biomeListsLocked = true;
            return this;
        }

        public BiomeConfig allowedBiomes(String ... biomes) {
            return this.allowedBiomes((ResourceLocation[])Arrays.stream(biomes).map(ResourceLocation::new).toArray(ResourceLocation[]::new));
        }

        @SafeVarargs
        public final BiomeConfig allowedBiomes(RegistryKey<Biome> ... biomes) {
            return this.allowedBiomes((ResourceLocation[])Arrays.stream(biomes).map(RegistryKey::func_240901_a_).toArray(ResourceLocation[]::new));
        }

        public BiomeConfig ignoredBiomes(ResourceLocation ... biomes) {
            if (this.biomeListsLocked) {
                return this;
            }
            this.ignoredBiomes.addAll(Arrays.asList(biomes));
            this.biomeListsLocked = true;
            return this;
        }

        public BiomeConfig ignoredBiomes(String ... biomes) {
            return this.ignoredBiomes((ResourceLocation[])Arrays.stream(biomes).map(ResourceLocation::new).toArray(ResourceLocation[]::new));
        }

        @SafeVarargs
        public final BiomeConfig ignoredBiomes(RegistryKey<Biome> ... biomes) {
            return this.ignoredBiomes((ResourceLocation[])Arrays.stream(biomes).map(RegistryKey::func_240901_a_).toArray(ResourceLocation[]::new));
        }

        public List<ResourceLocation> allowedBiomes() {
            return new ArrayList<ResourceLocation>(this.allowedBiomes);
        }

        public List<ResourceLocation> ignoredBiomes() {
            return new ArrayList<ResourceLocation>(this.ignoredBiomes);
        }
    }
}

