/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features.configs;

import dev.falsegamemaster.ihatecores.registration.features.IStructurePredicate;
import dev.falsegamemaster.ihatecores.registration.features.configs.IFullFeatureConfig;
import dev.falsegamemaster.ihatecores.registration.features.configs.SchematicFeatureConfigOLD;
import dev.falsegamemaster.ihatecores.util.algorithms.BetterRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.Tags;

@Deprecated
public class CustomVegetalConfigOLD
extends SchematicFeatureConfigOLD<CustomVegetalConfigOLD> {
    protected boolean fastGen;
    protected int min;
    protected int max;
    protected int attempts;
    protected double average;
    protected IFullFeatureConfig.BiomeConfig biomeConfig;

    public CustomVegetalConfigOLD(ResourceLocation schematic) {
        super(schematic);
    }

    public CustomVegetalConfigOLD min(int minAmountPerChunk) {
        this.min = minAmountPerChunk;
        return this;
    }

    public CustomVegetalConfigOLD max(int maxAmountPerChunk) {
        this.max = maxAmountPerChunk;
        return this;
    }

    public CustomVegetalConfigOLD average(double averageAmountPerChunk) {
        this.average = averageAmountPerChunk;
        return this;
    }

    public CustomVegetalConfigOLD attempts(int attempts) {
        this.attempts = attempts;
        return this;
    }

    public CustomVegetalConfigOLD fastGen(boolean fastGen) {
        this.fastGen = fastGen;
        return this;
    }

    public CustomVegetalConfigOLD allowedBiomes(Consumer<IFullFeatureConfig.BiomeConfig> biomeConfig) {
        IFullFeatureConfig.BiomeConfig biomeConfig1 = new IFullFeatureConfig.BiomeConfig();
        biomeConfig.accept(biomeConfig1);
        this.biomeConfig = biomeConfig1;
        return this;
    }

    @Override
    public List<ResourceLocation> allowedBiomes() {
        return this.biomeConfig.allowedBiomes();
    }

    @Override
    public List<ResourceLocation> ignoredBiomes() {
        return this.biomeConfig.ignoredBiomes();
    }

    @Override
    public int minAmountPerChunk() {
        return this.min;
    }

    @Override
    public int maxAmountPerChunk() {
        return this.max;
    }

    @Override
    public double averageAmountPerChunk() {
        return this.average;
    }

    @Override
    public int spawnAttempts() {
        return this.attempts;
    }

    public boolean fastGeneration() {
        return this.fastGen;
    }

    public boolean isValidSurface(IBlockReader reader, BlockPos pos) {
        Block block = reader.func_180495_p(pos.func_177977_b()).func_177230_c();
        return Tags.Blocks.DIRT.func_230235_a_((Object)block);
    }

    protected boolean isClearOfOtherPositions(BlockPos pos, List<BlockPos> positions, int radius) {
        radius *= 2;
        for (BlockPos other : positions) {
            boolean zInBounds;
            int x = other.func_177958_n() - pos.func_177958_n();
            int z = other.func_177952_p() - pos.func_177952_p();
            boolean xInBounds = -radius <= x && x <= radius;
            boolean bl = zInBounds = -radius <= z && z <= radius;
            if (!xInBounds || !zInBounds) continue;
            return false;
        }
        return true;
    }

    protected boolean isClearOfOtherBlocksAtY(ISeedReader reader, BlockPos pos, int radius) {
        for (int x = -(radius *= 2); x < radius + 1; ++x) {
            for (int z = -radius; z < radius + 1; ++z) {
                BlockPos offset = pos.func_177982_a(x, 0, z);
                if (reader.func_180495_p(offset).func_185904_a().func_76222_j()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isClearOfOtherBlocks(ISeedReader reader, BlockPos pos, int radius, int height) {
        for (int y = 0; y < height; ++y) {
            if (this.isClearOfOtherBlocksAtY(reader, pos.func_177982_a(0, y, 0), radius)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidQuickPosition(ISeedReader reader, BlockPos pos) {
        return pos.func_177956_o() != 0 && this.isValidSurface((IBlockReader)reader, pos);
    }

    protected BlockPos rotate90aboutY(BlockPos pos, BlockPos center, int times) {
        assert (times >= 0);
        BlockPos rel = pos.func_177973_b((Vector3i)center);
        switch (times %= 4) {
            default: {
                return pos;
            }
            case 1: {
                rel = new BlockPos(rel.func_177952_p(), rel.func_177956_o(), -rel.func_177958_n());
            }
            case 2: {
                rel = new BlockPos(-rel.func_177958_n(), rel.func_177956_o(), -rel.func_177952_p());
            }
            case 3: 
        }
        rel = new BlockPos(-rel.func_177952_p(), rel.func_177956_o(), rel.func_177958_n());
        return rel.func_177971_a((Vector3i)center);
    }

    public Stream<BlockPos> get1PositionInChunk(ISeedReader reader, BetterRandom random, BlockPos chunkPos, int radius) {
        BlockPos pos0 = new BlockPos(chunkPos.func_177958_n() + random.nextInt(radius, 16 - radius), 0, chunkPos.func_177952_p() + random.nextInt(radius, 16 - radius));
        Heightmap.Type heightMap = Heightmap.Type.MOTION_BLOCKING_NO_LEAVES;
        pos0 = reader.func_205770_a(heightMap, pos0);
        return Stream.of(pos0).filter(pos -> this.isValidQuickPosition(reader, (BlockPos)pos));
    }

    public Stream<BlockPos> get2PositionInChunk(ISeedReader reader, BetterRandom random, BlockPos chunkPos, int radius) {
        BlockPos pos1;
        BlockPos pos0;
        int x = chunkPos.func_177958_n();
        int z = chunkPos.func_177952_p();
        int ranPos = random.nextInt(2);
        int longSide = random.nextInt(radius, 16 - radius);
        int shortSide0 = random.nextInt(radius, 8 - radius);
        int shortSide1 = random.nextInt(8 + radius, 16 - radius);
        if (ranPos == 0) {
            pos0 = new BlockPos(x + longSide, 0, z + shortSide0);
            pos1 = new BlockPos(x + longSide, 0, z + shortSide1);
        } else {
            pos0 = new BlockPos(x + shortSide0, 0, z + longSide);
            pos1 = new BlockPos(x + shortSide1, 0, z + longSide);
        }
        Heightmap.Type heightMap = Heightmap.Type.MOTION_BLOCKING_NO_LEAVES;
        pos0 = reader.func_205770_a(heightMap, pos0);
        pos1 = reader.func_205770_a(heightMap, pos1);
        return Stream.of(pos0, pos1).filter(pos -> this.isValidQuickPosition(reader, (BlockPos)pos));
    }

    public Stream<BlockPos> get3PositionInChunk(ISeedReader reader, BetterRandom random, BlockPos chunkPos, int radius) {
        int x = chunkPos.func_177958_n();
        int z = chunkPos.func_177952_p();
        int ranPos = random.nextInt(4);
        BlockPos center = new BlockPos(x + 8, 0, z + 8);
        int longSide = random.nextInt(radius, 16 - radius);
        int shortSide0 = random.nextInt(radius, 8 - radius);
        int shortSide1 = random.nextInt(8 + radius, 16 - radius);
        BlockPos pos0 = this.rotate90aboutY(new BlockPos(x + shortSide0, 0, z + shortSide0), center, ranPos);
        BlockPos pos1 = this.rotate90aboutY(new BlockPos(x + shortSide0, 0, z + shortSide1), center, ranPos);
        BlockPos pos2 = this.rotate90aboutY(new BlockPos(x + shortSide1, 0, z + longSide), center, ranPos);
        Heightmap.Type heightMap = Heightmap.Type.MOTION_BLOCKING_NO_LEAVES;
        pos0 = reader.func_205770_a(heightMap, pos0);
        pos1 = reader.func_205770_a(heightMap, pos1);
        pos2 = reader.func_205770_a(heightMap, pos2);
        return Stream.of(pos0, pos1, pos2).filter(pos -> this.isValidQuickPosition(reader, (BlockPos)pos));
    }

    public Stream<BlockPos> get4PositionInChunk(ISeedReader reader, BetterRandom random, BlockPos chunkPos, int radius) {
        int x = chunkPos.func_177958_n();
        int z = chunkPos.func_177952_p();
        int shortSide0 = random.nextInt(radius, 8 - radius);
        int shortSide1 = random.nextInt(8 + radius, 16 - radius);
        BlockPos pos0 = new BlockPos(x + shortSide0, 0, z + shortSide0);
        BlockPos pos1 = new BlockPos(x + shortSide0, 0, z + shortSide1);
        BlockPos pos2 = new BlockPos(x + shortSide1, 0, z + shortSide0);
        BlockPos pos3 = new BlockPos(x + shortSide1, 0, z + shortSide1);
        Heightmap.Type heightMap = Heightmap.Type.MOTION_BLOCKING_NO_LEAVES;
        pos0 = reader.func_205770_a(heightMap, pos0);
        pos1 = reader.func_205770_a(heightMap, pos1);
        pos2 = reader.func_205770_a(heightMap, pos2);
        pos3 = reader.func_205770_a(heightMap, pos3);
        return Stream.of(pos0, pos1, pos2, pos3).filter(pos -> this.isValidQuickPosition(reader, (BlockPos)pos));
    }

    protected boolean isValidPosition(ISeedReader reader, BlockPos pos, Template feature, List<BlockPos> positions, int radius) {
        return pos.func_177956_o() != 0 && this.isValidSurface((IBlockReader)reader, pos) && this.isClearOfOtherPositions(pos, positions, radius) && this.isClearOfOtherBlocks(reader, pos, radius, feature.func_186259_a().func_177956_o());
    }

    public Optional<BlockPos> getPositionInChunk(ISeedReader reader, Random random, BlockPos chunkPos, Template feature, List<BlockPos> positions, int attempts, int radius) {
        if (attempts < 1) {
            return Optional.empty();
        }
        BlockPos size = feature.func_186259_a();
        int subRadius = radius >> 1;
        int x = chunkPos.func_177958_n() + subRadius + random.nextInt(16 - subRadius);
        int z = chunkPos.func_177952_p() + subRadius + random.nextInt(16 - subRadius);
        BlockPos pos = new BlockPos(x, 0, z);
        return this.isValidPosition(reader, pos = reader.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos), feature, positions, radius) ? Optional.of(pos) : this.getPositionInChunk(reader, random, chunkPos, feature, positions, attempts - 1, radius);
    }

    @Override
    public Stream<BlockPos> getPositionsInChunk(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos chunkPos, Template feature) {
        BetterRandom random1 = BetterRandom.of(random);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int amount = this.amountInChunk(new Random(random.nextLong()));
        BlockPos size = feature.func_186259_a();
        int radius = Math.max(size.func_177958_n(), size.func_177952_p()) >> 1;
        if (this.fastGen) {
            if (amount > 4) {
                amount = 4;
            }
            switch (amount) {
                default: {
                    return Stream.empty();
                }
                case 1: {
                    return this.get1PositionInChunk(reader, random1, chunkPos, radius);
                }
                case 2: {
                    return this.get2PositionInChunk(reader, random1, chunkPos, radius);
                }
                case 3: {
                    return this.get3PositionInChunk(reader, random1, chunkPos, radius);
                }
                case 4: 
            }
            return this.get4PositionInChunk(reader, random1, chunkPos, radius);
        }
        for (int i = 0; i < amount; ++i) {
            this.getPositionInChunk(reader, random, chunkPos, feature, positions, this.spawnAttempts(), radius).ifPresent(positions::add);
        }
        return positions.stream();
    }

    @Override
    public PlacementSettings getPlacementSettings(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos original, BlockPos.Mutable mutable, Template template, CompoundNBT nbt) {
        BlockPos size = template.func_186259_a();
        int x = size.func_177958_n() >> 1;
        int z = size.func_177952_p() >> 1;
        mutable.func_196234_d(-x, 0, -z);
        PlacementSettings settings = super.getPlacementSettings(reader, generator, random, original, mutable, template, nbt);
        settings.func_207665_a(new BlockPos(x, 0, z));
        settings.func_215222_a(IStructurePredicate.REPLACE_REPLACEABLE.get());
        return settings;
    }
}

