/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features.categories;

import com.mojang.serialization.Codec;
import dev.falsegamemaster.ihatecores.registration.features.categories.FullFeature;
import dev.falsegamemaster.ihatecores.registration.features.configs.IVanillaFeatureConfig;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.serialization.CodecUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BasaltDeltasFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlobReplacementConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.ColumnConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.EndSpikeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.FillLayerConfig;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;

@ParametersAreNonnullByDefault
public class VanillaFeature<FC extends IFeatureConfig, VFC extends IVanillaFeatureConfig<FC>>
extends FullFeature<VFC> {
    public static final Map<Class<? extends IFeatureConfig>, Codec<? extends IFeatureConfig>> CODEC_MAP = new HashMap<Class<? extends IFeatureConfig>, Codec<? extends IFeatureConfig>>();
    protected final Feature<FC> vanillaFeature;

    public static <FC extends IFeatureConfig> Codec<FC> getCodecForFeatureConfig(Class<FC> clazz) {
        return (Codec)GenericsUtil.castOrNull(CODEC_MAP.get(clazz));
    }

    protected static <FC extends IFeatureConfig, F extends Feature<FC>> Codec<FC> initCodec(ConfiguredFeature<FC, F> configuredFeature) {
        return VanillaFeature.getCodecForFeatureConfig((Class)GenericsUtil.castOrNull(configuredFeature.field_222738_b.getClass()));
    }

    protected static <FC extends IFeatureConfig> Codec<FC> initCodec(FC vanillaConfig) {
        return VanillaFeature.getCodecForFeatureConfig((Class)GenericsUtil.castOrNull(vanillaConfig.getClass()));
    }

    public VanillaFeature(Feature<FC> vanillaFeature, Class<VFC> clazz, GenerationStage.Decoration stage) {
        super(CodecUtil.getCodec("config", clazz), stage);
        this.vanillaFeature = vanillaFeature;
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos pos, VFC config) {
        return this.vanillaFeature.func_241855_a(reader, generator, random, pos, config.getVanillaConfig());
    }

    @Override
    public void generateInBiome(BiomeLoadingEvent event, VFC config) {
        event.getGeneration().func_242513_a(this.getGenerationStage(), this.vanillaFeature.func_225566_b_(config.getVanillaConfig()));
    }

    static {
        CODEC_MAP.put(NoFeatureConfig.class, (Codec<? extends IFeatureConfig>)NoFeatureConfig.field_236558_a_);
        CODEC_MAP.put(BaseTreeFeatureConfig.class, (Codec<? extends IFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_);
        CODEC_MAP.put(BlockClusterFeatureConfig.class, (Codec<? extends IFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_);
        CODEC_MAP.put(BlockStateProvidingFeatureConfig.class, (Codec<? extends IFeatureConfig>)BlockStateProvidingFeatureConfig.field_236453_a_);
        CODEC_MAP.put(LiquidsConfig.class, (Codec<? extends IFeatureConfig>)LiquidsConfig.field_236649_a_);
        CODEC_MAP.put(ReplaceBlockConfig.class, (Codec<? extends IFeatureConfig>)ReplaceBlockConfig.field_236604_a_);
        CODEC_MAP.put(BigMushroomFeatureConfig.class, (Codec<? extends IFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        CODEC_MAP.put(BlockStateFeatureConfig.class, (Codec<? extends IFeatureConfig>)BlockStateFeatureConfig.field_236455_a_);
        CODEC_MAP.put(SphereReplaceConfig.class, (Codec<? extends IFeatureConfig>)SphereReplaceConfig.field_236516_a_);
        CODEC_MAP.put(OreFeatureConfig.class, (Codec<? extends IFeatureConfig>)OreFeatureConfig.field_236566_a_);
        CODEC_MAP.put(EndSpikeFeatureConfig.class, (Codec<? extends IFeatureConfig>)EndSpikeFeatureConfig.field_236644_a_);
        CODEC_MAP.put(EndGatewayConfig.class, (Codec<? extends IFeatureConfig>)EndGatewayConfig.field_236522_a_);
        CODEC_MAP.put(ProbabilityConfig.class, (Codec<? extends IFeatureConfig>)ProbabilityConfig.field_236576_b_);
        CODEC_MAP.put(FeatureSpreadConfig.class, (Codec<? extends IFeatureConfig>)FeatureSpreadConfig.field_242797_a);
        CODEC_MAP.put(BlockWithContextConfig.class, (Codec<? extends IFeatureConfig>)BlockWithContextConfig.field_236636_a_);
        CODEC_MAP.put(HugeFungusConfig.class, (Codec<? extends IFeatureConfig>)HugeFungusConfig.field_236298_a_);
        CODEC_MAP.put(ColumnConfig.class, (Codec<? extends IFeatureConfig>)ColumnConfig.field_236465_a_);
        CODEC_MAP.put(BasaltDeltasFeature.class, (Codec<? extends IFeatureConfig>)BasaltDeltasFeature.field_236495_a_);
        CODEC_MAP.put(BlobReplacementConfig.class, (Codec<? extends IFeatureConfig>)BlobReplacementConfig.field_242817_a);
        CODEC_MAP.put(FillLayerConfig.class, (Codec<? extends IFeatureConfig>)FillLayerConfig.field_236537_a_);
        CODEC_MAP.put(MultipleRandomFeatureConfig.class, (Codec<? extends IFeatureConfig>)MultipleRandomFeatureConfig.field_236583_a_);
        CODEC_MAP.put(SingleRandomFeature.class, (Codec<? extends IFeatureConfig>)SingleRandomFeature.field_236642_a_);
        CODEC_MAP.put(TwoFeatureChoiceConfig.class, (Codec<? extends IFeatureConfig>)TwoFeatureChoiceConfig.field_236579_a_);
        CODEC_MAP.put(DecoratedFeatureConfig.class, (Codec<? extends IFeatureConfig>)DecoratedFeatureConfig.field_236491_a_);
    }
}

