/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features.categories;

import com.mojang.serialization.Codec;
import dev.falsegamemaster.ihatecores.registration.features.categories.FullFeature;
import dev.falsegamemaster.ihatecores.registration.features.configs.ISchematicFeatureConfig;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

@ParametersAreNonnullByDefault
public class SchematicFeature<FC extends ISchematicFeatureConfig<FC>>
extends FullFeature<FC> {
    public SchematicFeature(Codec<FC> codec, GenerationStage.Decoration stage) {
        super(codec, stage);
    }

    public SchematicFeature(Class<FC> clazz, GenerationStage.Decoration stage) {
        super(clazz, stage);
    }

    protected List<Template> getTemplates(ISeedReader reader, FC config) {
        TemplateManager manager = reader.func_201672_e().func_184163_y();
        return config.getSchematics().stream().map(arg_0 -> ((TemplateManager)manager).func_200219_b(arg_0)).collect(Collectors.toList());
    }

    protected boolean placeSchematic(ISeedReader reader, Random random, BlockPos pos, @Nullable List<Template> templates, List<PlacementSettings> placementSettings) {
        if (templates == null || templates.size() != placementSettings.size()) {
            return false;
        }
        for (int i = 0; i < templates.size(); ++i) {
            templates.get(i).func_237146_a_((IServerWorld)reader, pos, pos, placementSettings.get(i), random, 18);
        }
        return true;
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos chunkPos, FC config) {
        List<Template> templates = this.getTemplates(reader, config);
        List positions = config.getPositionsInChunk(reader, generator, random, chunkPos, templates).collect(Collectors.toList());
        for (BlockPos original : positions) {
            List<PlacementSettings> placementSettings;
            CompoundNBT nbt = new CompoundNBT();
            BlockPos.Mutable mutable = original.func_239590_i_();
            if (!config.configureSchematics(reader, generator, random, original, mutable, templates, placementSettings = config.getPlacementSettings(reader, generator, random, original, mutable, templates, nbt), nbt)) {
                return false;
            }
            if (!this.placeSchematic(reader, random, (BlockPos)mutable, templates, placementSettings)) {
                return false;
            }
            if (config.decorateSchematics(reader, generator, random, original, templates, nbt)) continue;
            return false;
        }
        return true;
    }
}

