/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features.categories;

import com.mojang.serialization.Codec;
import dev.falsegamemaster.ihatecores.registration.features.configs.IFullFeatureConfig;
import dev.falsegamemaster.ihatecores.util.serialization.CodecUtil;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public abstract class FullFeature<FC extends IFullFeatureConfig>
extends Feature<FC> {
    protected final GenerationStage.Decoration stage;

    public FullFeature(Codec<FC> codec, GenerationStage.Decoration stage) {
        super(codec);
        this.stage = stage;
    }

    public FullFeature(Class<FC> clazz, GenerationStage.Decoration stage) {
        this(CodecUtil.getCodec("config", clazz), stage);
    }

    public GenerationStage.Decoration getGenerationStage() {
        return this.stage;
    }

    public boolean shouldGenerate(BiomeLoadingEvent event, FC config) {
        return true;
    }

    public final void generate(BiomeLoadingEvent event, FC config) {
        List<ResourceLocation> allowedBiomes = config.allowedBiomes();
        List<ResourceLocation> ignoredBiomes = config.ignoredBiomes();
        if (!allowedBiomes.isEmpty()) {
            this.generateInWhitelistedBiomes(event, config);
        } else if (!ignoredBiomes.isEmpty()) {
            this.generateInNonBlacklistedBiomes(event, config);
        } else if (this.shouldGenerate(event, config)) {
            this.generateInBiome(event, config);
        }
    }

    private void generateInWhitelistedBiomes(BiomeLoadingEvent event, FC config) {
        List<ResourceLocation> allowedBiomes = config.allowedBiomes();
        for (ResourceLocation listedBiomeName : allowedBiomes) {
            ResourceLocation eventBiomeName = event.getName();
            if (listedBiomeName == null || !listedBiomeName.equals((Object)eventBiomeName) || !this.shouldGenerate(event, config)) continue;
            this.generateInBiome(event, config);
            return;
        }
    }

    private void generateInNonBlacklistedBiomes(BiomeLoadingEvent event, FC config) {
        List<ResourceLocation> ignoredBiomes = config.ignoredBiomes();
        for (ResourceLocation listedBiomeName : ignoredBiomes) {
            ResourceLocation eventBiomeName = event.getName();
            if (listedBiomeName == null || listedBiomeName.equals((Object)eventBiomeName) || !this.shouldGenerate(event, config)) continue;
            this.generateInBiome(event, config);
            return;
        }
    }

    public void generateInBiome(BiomeLoadingEvent event, FC config) {
        event.getGeneration().func_242513_a(this.getGenerationStage(), this.func_225566_b_((IFeatureConfig)config));
    }
}

