/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features;

import dev.falsegamemaster.ihatecores.registration.features.processors.PredicateProcessor;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public interface IStructurePredicate {
    public static final IStructurePredicate NONE = (reader, newState, oldState, pos, chunkPos, random) -> false;
    public static final IStructurePredicate IGNORE_AIR = (reader, newState, oldState, pos, chunkPos, random) -> !newState.func_203425_a(Blocks.field_150350_a);
    public static final IStructurePredicate NO_REPLACE = (reader, newState, oldState, pos, chunkPos, random) -> oldState.func_203425_a(Blocks.field_150350_a);
    public static final IStructurePredicate REPLACE_LEAVES = (reader, newState, oldState, pos, chunkPos, random) -> oldState.func_235714_a_((ITag)BlockTags.field_206952_E);
    public static final IStructurePredicate REPLACE_NON_SOLID = (reader, newState, oldState, pos, chunkPos, random) -> !oldState.func_200015_d(reader, pos);
    public static final IStructurePredicate REPLACE_PLANTS = (reader, newState, oldState, pos, chunkPos, random) -> oldState.func_185904_a() == Material.field_151582_l;
    public static final IStructurePredicate REPLACE_REPLACEABLE = (reader, newState, oldState, pos, chunkPos, random) -> oldState.func_185904_a().func_76222_j();
    public static final IStructurePredicate VALID_TREE_POS = (reader, newState, oldState, pos, chunkPos, random) -> TreeFeature.func_236404_a_((IWorldGenerationBaseReader)((IWorldGenerationBaseReader)reader), (BlockPos)pos);

    public static IStructurePredicate not(IStructurePredicate predicate) {
        return (re, ns, os, po, cp, ra) -> !predicate.shouldPlace(re, ns, os, po, cp, ra);
    }

    public boolean shouldPlace(IBlockReader var1, BlockState var2, BlockState var3, BlockPos var4, BlockPos var5, Random var6);

    default public StructureProcessor get() {
        return PredicateProcessor.of(this).get();
    }

    default public IStructurePredicate not() {
        return (re, ns, os, po, cp, ra) -> !this.shouldPlace(re, ns, os, po, cp, ra);
    }

    default public IStructurePredicate or(IStructurePredicate other) {
        return (re, ns, os, po, cp, ra) -> this.shouldPlace(re, ns, os, po, cp, ra) || other.shouldPlace(re, ns, os, po, cp, ra);
    }

    default public IStructurePredicate and(IStructurePredicate other) {
        return (re, ns, os, po, cp, ra) -> this.shouldPlace(re, ns, os, po, cp, ra) && other.shouldPlace(re, ns, os, po, cp, ra);
    }
}

