/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.features;

import dev.falsegamemaster.ihatecores.api.RegistryMap;
import dev.falsegamemaster.ihatecores.registration.config.Config;
import dev.falsegamemaster.ihatecores.registration.events.InGameEventHandler;
import dev.falsegamemaster.ihatecores.registration.features.categories.FeatureCategoryMap;
import dev.falsegamemaster.ihatecores.registration.features.categories.FullFeature;
import dev.falsegamemaster.ihatecores.registration.features.categories.VanillaFeature;
import dev.falsegamemaster.ihatecores.registration.features.configs.IFullFeatureConfig;
import dev.falsegamemaster.ihatecores.registration.features.configs.IVanillaFeatureConfig;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FeatureMap
extends RegistryMap<ConfiguredFeature<?, ?>>
implements InGameEventHandler {
    protected final Config config;
    protected FeatureCategoryMap categories = new FeatureCategoryMap();
    protected final List<ConfiguredFeature<?, ?>> queue = new ArrayList();

    public FeatureMap(Config config) {
        super(ConfiguredFeature.class);
        this.config = config;
    }

    public FeatureMap(Config config, FeatureCategoryMap categories) {
        this(config);
        this.categories = categories;
    }

    @Override
    @Deprecated
    public ConfiguredFeature<?, ?> put(String name, ConfiguredFeature<?, ?> feature) {
        this.queue.add(feature);
        return super.put(name, feature);
    }

    public <FC extends IFeatureConfig, VFC extends IVanillaFeatureConfig<FC>, F extends Feature<FC>> ConfiguredFeature<?, ?> put(String name, ConfiguredFeature<FC, F> configuredFeature, GenerationStage.Decoration stage, Consumer<IFullFeatureConfig.BiomeConfig> biomeConfig) {
        IVanillaFeatureConfig config = (IVanillaFeatureConfig)GenericsUtil.castOrNull(IVanillaFeatureConfig.of(configuredFeature.field_222738_b, biomeConfig));
        VanillaFeature vanillaFeature = new VanillaFeature(configuredFeature.field_222737_a, (Class)GenericsUtil.castOrNull(config.getClass()), stage);
        return this.put(name, vanillaFeature.func_225566_b_(config));
    }

    public <FC extends IFullFeatureConfig> ConfiguredFeature<?, ?> put2(String category, String feature, String[] schematics, Function<List<ResourceLocation>, FC> featureConfig, Consumer<FC> settings) {
        IFullFeatureConfig config = (IFullFeatureConfig)featureConfig.apply(Stream.of(schematics).map(s -> ResourceLocationUtil.parse(this.modid, s)).collect(Collectors.toList()));
        settings.accept(config);
        Feature feature1 = (Feature)GenericsUtil.castOrNull(Registry.field_218379_q.func_82594_a(ResourceLocationUtil.parse(this.modid, category)));
        return this.put(feature, feature1.func_225566_b_((IFeatureConfig)config));
    }

    public <FC extends IFullFeatureConfig> ConfiguredFeature<?, ?> put(String category, String feature, String[] schematics, Function<List<ResourceLocation>, FC> featureConfig, Consumer<FC> settings) {
        IFullFeatureConfig config = (IFullFeatureConfig)featureConfig.apply(Stream.of(schematics).map(s -> new ResourceLocation(this.modid, s)).collect(Collectors.toList()));
        settings.accept(config);
        Feature feature1 = (Feature)this.categories.get(category);
        return this.put(feature, feature1.func_225566_b_((IFeatureConfig)config));
    }

    @Deprecated
    public <FC extends IFullFeatureConfig> ConfiguredFeature<?, ?> put(String category, String feature, String schematic, Function<ResourceLocation, FC> featureConfig, Consumer<FC> settings) {
        IFullFeatureConfig config = (IFullFeatureConfig)featureConfig.apply(new ResourceLocation(this.modid, schematic));
        settings.accept(config);
        Feature feature1 = (Feature)this.categories.get(category);
        return this.put(feature, feature1.func_225566_b_((IFeatureConfig)config));
    }

    @Deprecated
    public <FC extends IFullFeatureConfig> ConfiguredFeature<?, ?> put(String category, String feature, Function<ResourceLocation, FC> featureConfig, Consumer<FC> settings) {
        return this.put(category, feature, feature, featureConfig, settings);
    }

    @Deprecated
    public <FC extends IFullFeatureConfig> ConfiguredFeature<?, ?> put(String category, String feature, String schematic, Function<ResourceLocation, FC> featureConfig) {
        return this.put(category, feature, schematic, featureConfig, (FC config) -> {});
    }

    @Deprecated
    public <FC extends IFullFeatureConfig> ConfiguredFeature<?, ?> put(String category, String feature, Function<ResourceLocation, FC> featureConfig) {
        return this.put(category, feature, featureConfig, (FC config) -> {});
    }

    @SubscribeEvent
    protected <FC extends IFullFeatureConfig, F extends FullFeature<FC>> void generateFeatures(BiomeLoadingEvent event) {
        this.queue.forEach((? super T configuredFeature) -> {
            if (!(configuredFeature.field_222737_a instanceof FullFeature)) {
                return;
            }
            ConfiguredFeature configuredFeature1 = (ConfiguredFeature)GenericsUtil.castOrNull(configuredFeature);
            ((FullFeature)configuredFeature1.field_222737_a).generate(event, (IFullFeatureConfig)configuredFeature1.field_222738_b);
        });
    }
}

