/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.events;

import dev.falsegamemaster.ihatecores.registration.blocks.IBlockColorWrapper;
import dev.falsegamemaster.ihatecores.registration.blocks.IDynamicColorBlock;
import dev.falsegamemaster.ihatecores.registration.items.IDynamicColorItem;
import dev.falsegamemaster.ihatecores.registration.items.IItemColorWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.DistExecutor;

public class ColorRegistry {
    private final Map<IItemColorWrapper, IItemProvider> itemProviderQueue = new LinkedHashMap<IItemColorWrapper, IItemProvider>();
    private final Map<IBlockColorWrapper, Block> blockQueue = new LinkedHashMap<IBlockColorWrapper, Block>();

    public void register(ColorHandlerEvent.Item event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlockColors blockColors = event.getBlockColors();
            ItemColors itemColors = event.getItemColors();
            this.blockQueue.forEach((iBlockColorWrapper, block) -> {
                if (iBlockColorWrapper == null) {
                    return;
                }
                IItemColorWrapper iItemColorWrapper = (stack, color) -> IDynamicColorBlock.getColor(stack, color, iBlockColorWrapper);
                blockColors.func_186722_a(iBlockColorWrapper.get(), new Block[]{block});
                itemColors.func_199877_a(iItemColorWrapper.get(), new IItemProvider[]{block});
            });
            this.itemProviderQueue.forEach((iItemColorWrapper, itemProvider) -> {
                if (iItemColorWrapper == null) {
                    return;
                }
                itemColors.func_199877_a(iItemColorWrapper.get(), new IItemProvider[]{itemProvider});
            });
        });
    }

    public void register(IItemProvider itemProvider, IItemColorWrapper iItemColor) {
        this.itemProviderQueue.put(iItemColor, itemProvider);
    }

    public void register(IItemProvider itemProvider) {
        if (!(itemProvider instanceof IDynamicColorItem)) {
            return;
        }
        IDynamicColorItem colorItem = (IDynamicColorItem)itemProvider;
        this.register(itemProvider, colorItem::getColor);
    }

    public void register(Block block, IBlockColorWrapper iBlockColorWrapper) {
        this.blockQueue.put(iBlockColorWrapper, block);
    }

    public void register(Block block) {
        if (!(block instanceof IDynamicColorBlock)) {
            return;
        }
        IDynamicColorBlock colorBlock = (IDynamicColorBlock)block;
        this.register(block, colorBlock::getColor);
    }
}

