/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.entities;

import dev.falsegamemaster.ihatecores.api.ForgeRegistryMap;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.FakeWorld;
import dev.falsegamemaster.ihatecores.registration.entities.IEntityFactory;
import dev.falsegamemaster.ihatecores.registration.entities.ITextureRenderFactory;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.ResourceLocationUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityMap
extends ForgeRegistryMap<EntityType<?>> {
    protected final Map<EntityType<? extends Entity>, IRenderFactory<? extends Entity>> queue = new HashMap<EntityType<? extends Entity>, IRenderFactory<? extends Entity>>();

    public EntityMap() {
        super(EntityType.class);
    }

    protected <E extends Entity> IRenderFactory<E> getVanillaRenderFactory(ITextureRenderFactory<E> factory, ResourceLocation texture) {
        return (IRenderFactory)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> manager -> factory.createRenderFor(manager, texture));
    }

    protected <E extends Entity> EntityType<E> putInternal(String name, String pickItem, IEntityFactory<E> factory, EntityClassification category, Consumer<EntityType.Builder<E>> consumer) {
        EntityType.IFactory vanillaFactory = (type, world) -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(pickItem));
            return factory.create(type, world, item);
        };
        EntityType.Builder builder = EntityType.Builder.func_220322_a((EntityType.IFactory)vanillaFactory, (EntityClassification)category);
        consumer.accept(builder);
        EntityType type2 = builder.func_206830_a(this.modid + ":" + name);
        this.put(name, type2);
        return type2;
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, String pickItem, IEntityFactory<E> factory, EntityClassification category, Consumer<EntityType.Builder<E>> consumer, ITextureRenderFactory<E> renderer) {
        EntityType<E> type = this.putInternal(name, pickItem, factory, category, consumer);
        ResourceLocation loc = ResourceLocationUtil.parse(this.modid, texture + ".png");
        this.queue.put(type, this.getVanillaRenderFactory(renderer, loc));
        return type;
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, String pickItem, IEntityFactory<E> factory, EntityClassification category, Consumer<EntityType.Builder<E>> consumer) {
        EntityType<E> type = this.putInternal(name, pickItem, factory, category, consumer);
        Entity entity = type.func_200721_a((World)new FakeWorld());
        if (entity instanceof ITextureRenderFactory) {
            ITextureRenderFactory renderer = (ITextureRenderFactory)entity;
            ResourceLocation loc = ResourceLocationUtil.parse(this.modid, texture + ".png");
            this.queue.put(type, (IRenderFactory<? extends Entity>)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> this.getVanillaRenderFactory(renderer, loc)));
        }
        return type;
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, IEntityFactory<E> factory, EntityClassification category, Consumer<EntityType.Builder<E>> consumer) {
        return this.put(name, texture, this.modid + ":" + name, factory, category, consumer);
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, IEntityFactory<E> factory, EntityClassification category, Consumer<EntityType.Builder<E>> consumer, ITextureRenderFactory<E> renderer) {
        return this.put(name, texture, this.modid + ":" + name, factory, category, consumer, renderer);
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, String pickItem, IEntityFactory<E> factory, EntityClassification category, ITextureRenderFactory<E> renderer) {
        return this.put(name, texture, pickItem, factory, category, b -> {}, renderer);
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, String pickItem, IEntityFactory<E> factory, EntityClassification category) {
        return this.put(name, texture, pickItem, factory, category, (EntityType.Builder<E> b) -> {});
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, IEntityFactory<E> factory, EntityClassification category) {
        return this.put(name, texture, this.modid + ":" + name, factory, category, (EntityType.Builder<E> b) -> {});
    }

    public <E extends Entity> EntityType<E> put(String name, String texture, IEntityFactory<E> factory, EntityClassification category, ITextureRenderFactory<E> renderer) {
        return this.put(name, texture, this.modid + ":" + name, factory, category, b -> {}, renderer);
    }

    protected <E extends Entity> void bindRenderersWithGenerics() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.queue.forEach((type, renderer) -> {
            EntityType type1 = (EntityType)GenericsUtil.castOrNull(type);
            IRenderFactory renderer1 = (IRenderFactory)GenericsUtil.castOrNull(renderer);
            RenderingRegistry.registerEntityRenderingHandler((EntityType)type1, (IRenderFactory)renderer1);
        }));
    }

    @SubscribeEvent
    public void bindRenderers(FMLClientSetupEvent event) {
        this.bindRenderersWithGenerics();
    }
}

