/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers.slots;

import dev.falsegamemaster.ihatecores.registration.block_entities.IRecipeInventory;
import dev.falsegamemaster.ihatecores.registration.containers.slots.SimpleSlot;
import dev.falsegamemaster.ihatecores.registration.recipes.CraftingResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ResultSlot
extends SimpleSlot {
    protected final List<Runnable> queue = new ArrayList<Runnable>();
    protected final List<SimpleSlot> ingredients = new ArrayList<SimpleSlot>();
    protected final IRecipeType<?> recipeType;
    protected CraftingResult craftingResult = CraftingResult.failure();

    public <I extends IInventory, C extends Container, R extends IRecipe<I>> ResultSlot(IRecipeType<?> recipeType, I inventory, PlayerInventory playerInventory, int x, int y) {
        super(inventory, playerInventory, x, y);
        this.recipeType = recipeType;
        this.mayPlace = stack -> false;
        this.onTake = (player, stack) -> {
            this.consumeIngredients();
            return stack;
        };
        this.setChanged = () -> {
            this.craftingResult = this.craftRecipe();
        };
    }

    protected CraftingResult craftRecipe() {
        if (!(this.field_75224_c instanceof IRecipeInventory)) {
            return CraftingResult.failure();
        }
        return ((IRecipeInventory)this.field_75224_c).craftRecipe();
    }

    public void consumeIngredients() {
        Optional<List<CraftingResult.RemainderInfo>> optional = this.craftingResult.getRemainders();
        if (!optional.isPresent()) {
            return;
        }
        List<CraftingResult.RemainderInfo> remainders = optional.get();
        for (int i = 0; i < this.ingredients.size() && i < remainders.size(); ++i) {
            ItemStack remainder;
            CraftingResult.RemainderInfo info = remainders.get(i);
            if (info.getInventoryRemainder().isPresent()) {
                this.ingredients.get(i).setNoUpdate(info.getInventoryRemainder().get());
            }
            if (!info.getPlayerRemainder().isPresent() || this.player.field_71071_by.func_70441_a(remainder = info.getPlayerRemainder().get())) continue;
            this.player.func_71019_a(remainder, true);
        }
        this.func_75218_e();
    }

    public void func_75220_a(ItemStack stack, ItemStack copy) {
        super.func_75220_a(stack, copy);
        this.consumeIngredients();
    }

    public <I extends IInventory, C extends Container, R extends IRecipe<I>> ResultSlot(IRecipeType<?> recipeType, I inventory, PlayerEntity player, int x, int y) {
        this(recipeType, inventory, player.field_71071_by, x, y);
    }

    public <I extends IInventory, C extends Container, R extends IRecipe<I>> ResultSlot(IRecipeType<?> recipeType, PlayerInventory playerInventory, int x, int y) {
        this(recipeType, playerInventory, playerInventory, x, y);
    }

    protected List<SimpleSlot> validateIngredients(List<Slot> ingredients) {
        return ingredients.stream().map(slot -> SimpleSlot.of(slot, this.player.field_71071_by)).collect(Collectors.toList());
    }

    public ResultSlot addIngredients(Slot ... ingredients) {
        this.ingredients.addAll(this.validateIngredients(Arrays.asList(ingredients)));
        return this;
    }

    public ResultSlot addIngredient(Slot slot) {
        this.ingredients.add(SimpleSlot.of(slot, this.player.field_71071_by));
        return this;
    }

    public ResultSlot addIngredients(Consumer<List<Slot>> consumer) {
        ArrayList slots = new ArrayList();
        consumer.accept(slots);
        slots.stream().filter(Objects::nonNull).forEach(this::addIngredient);
        return this;
    }

    @Deprecated
    public ResultSlot addIngredients(int count) {
        this.queue.add(() -> {});
        return this;
    }

    protected <I extends IInventory, R extends IRecipe<I>> void setupIngredients() {
        this.ingredients.forEach(i -> i.setChanged(slot -> this.func_75218_e()));
    }

    @Override
    public SimpleSlot setSlot(int slot) {
        SimpleSlot simpleSlot = super.setSlot(slot);
        this.queue.forEach(Runnable::run);
        this.setupIngredients();
        return simpleSlot;
    }

    public List<SimpleSlot> getIngredients() {
        return this.ingredients;
    }
}

