/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers.screens;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.falsegamemaster.ihatecores.registration.events.InGameEventHandler;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.AccessibilityScreen;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.LanguageScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.MultiplayerWarningScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsBridgeScreen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TweakedMainMenuScreen
extends Screen
implements InGameEventHandler {
    protected static boolean shouldFade = true;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final RenderSkyboxCube CUBE_MAP = new RenderSkyboxCube(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation ACCESSIBILITY_TEXTURE = new ResourceLocation("textures/gui/accessibility.png");
    private final boolean minceraftEasterEgg;
    @Nullable
    private String splash;
    private Button resetDemoButton;
    private static final ResourceLocation MINECRAFT_LOGO = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation MINECRAFT_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private boolean realmsNotificationsInitialized;
    private Screen realmsNotificationsScreen;
    private int copyrightWidth;
    private int copyrightX;
    private final RenderSkybox panorama = new RenderSkybox(CUBE_MAP);
    private final boolean fading;
    private long fadeInStart;
    private NotificationModUpdateScreen modUpdateNotification;

    @SubscribeEvent
    public static void onMainMenuOpened(GuiOpenEvent e) {
        if (e.getGui() instanceof MainMenuScreen && !Minecraft.func_71410_x().func_238216_r_()) {
            e.setGui((Screen)new TweakedMainMenuScreen(shouldFade));
            if (shouldFade) {
                shouldFade = false;
            }
        }
    }

    public TweakedMainMenuScreen() {
        this(false);
    }

    public TweakedMainMenuScreen(boolean fading) {
        super((ITextComponent)new TranslationTextComponent("narrator.screen.title"));
        this.fading = fading;
        this.minceraftEasterEgg = (double)new Random().nextFloat() < 1.0E-4;
    }

    private boolean realmsNotificationsEnabled() {
        return this.field_230706_i_.field_71474_y.field_183509_X && this.realmsNotificationsScreen != null;
    }

    public void func_231023_e_() {
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.func_231023_e_();
        }
    }

    public static CompletableFuture<Void> preloadResources(TextureManager p_213097_0_, Executor p_213097_1_) {
        return CompletableFuture.allOf(p_213097_0_.func_215268_a(MINECRAFT_LOGO, p_213097_1_), p_213097_0_.func_215268_a(MINECRAFT_EDITION, p_213097_1_), p_213097_0_.func_215268_a(PANORAMA_OVERLAY, p_213097_1_), CUBE_MAP.func_217617_a(p_213097_0_, p_213097_1_));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231178_ax__() {
        return false;
    }

    protected static NotificationModUpdateScreen init(TweakedMainMenuScreen guiMainMenu, Button modButton) {
        NotificationModUpdateScreen notificationModUpdateScreen = new NotificationModUpdateScreen(modButton);
        notificationModUpdateScreen.func_231152_a_(guiMainMenu.getMinecraft(), guiMainMenu.field_230708_k_, guiMainMenu.field_230709_l_);
        notificationModUpdateScreen.func_231160_c_();
        return notificationModUpdateScreen;
    }

    protected void func_231160_c_() {
        if (this.splash == null) {
            this.splash = this.field_230706_i_.func_213269_at().func_215276_a();
        }
        this.copyrightWidth = this.field_230712_o_.func_78256_a("Copyright Mojang AB. Do not distribute!");
        this.copyrightX = this.field_230708_k_ - this.copyrightWidth - 2;
        int i = 24;
        int j = this.field_230709_l_ / 4 + 48;
        Button modButton = null;
        if (this.field_230706_i_.func_71355_q()) {
            this.createDemoMenuOptions(j, 24);
        } else {
            this.createNormalMenuOptions(j, 24);
            modButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, j + 48, 98, 20, (ITextComponent)new TranslationTextComponent("fml.menu.mods"), button -> this.field_230706_i_.func_147108_a((Screen)new ModListScreen((Screen)this))));
        }
        this.modUpdateNotification = TweakedMainMenuScreen.init(this, modButton);
        this.func_230480_a_((Widget)new ImageButton(this.field_230708_k_ / 2 - 124, j + 72 + 12, 20, 20, 0, 106, 20, Button.field_230687_i_, 256, 256, p_213090_1_ -> this.field_230706_i_.func_147108_a((Screen)new LanguageScreen((Screen)this, this.field_230706_i_.field_71474_y, this.field_230706_i_.func_135016_M())), (ITextComponent)new TranslationTextComponent("narrator.button.language")));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, j + 72 + 12, 98, 20, (ITextComponent)new TranslationTextComponent("menu.options"), p_213096_1_ -> this.field_230706_i_.func_147108_a((Screen)new OptionsScreen((Screen)this, this.field_230706_i_.field_71474_y))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 2, j + 72 + 12, 98, 20, (ITextComponent)new TranslationTextComponent("menu.quit"), p_213094_1_ -> this.field_230706_i_.func_71400_g()));
        this.func_230480_a_((Widget)new ImageButton(this.field_230708_k_ / 2 + 104, j + 72 + 12, 20, 20, 0, 0, 20, ACCESSIBILITY_TEXTURE, 32, 64, p_213088_1_ -> this.field_230706_i_.func_147108_a((Screen)new AccessibilityScreen((Screen)this, this.field_230706_i_.field_71474_y)), (ITextComponent)new TranslationTextComponent("narrator.button.accessibility")));
        this.field_230706_i_.func_181537_a(false);
        if (this.field_230706_i_.field_71474_y.field_183509_X && !this.realmsNotificationsInitialized) {
            RealmsBridgeScreen realmsbridgescreen = new RealmsBridgeScreen();
            this.realmsNotificationsScreen = realmsbridgescreen.func_239555_b_((Screen)this);
            this.realmsNotificationsInitialized = true;
        }
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
    }

    private void createNormalMenuOptions(int p_73969_1_, int p_73969_2_) {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, p_73969_1_, 200, 20, (ITextComponent)new TranslationTextComponent("menu.singleplayer"), p_213089_1_ -> this.field_230706_i_.func_147108_a((Screen)new WorldSelectionScreen((Screen)this))));
        boolean flag = true;
        Button.ITooltip button$itooltip = flag ? Button.field_238486_s_ : (p_238659_1_, p_238659_2_, p_238659_3_, p_238659_4_) -> {
            if (!p_238659_1_.field_230693_o_) {
                this.func_238654_b_(p_238659_2_, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("title.multiplayer.disabled"), Math.max(this.field_230708_k_ / 2 - 43, 170)), p_238659_3_, p_238659_4_);
            }
        };
        ((Button)this.func_230480_a_((Widget)new Button((int)(this.field_230708_k_ / 2 - 100), (int)(p_73969_1_ + p_73969_2_ * 1), (int)200, (int)20, (ITextComponent)new TranslationTextComponent((String)"menu.multiplayer"), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$createNormalMenuOptions$7(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((TweakedMainMenuScreen)this), (Button.ITooltip)button$itooltip))).field_230693_o_ = flag;
        ((Button)this.func_230480_a_((Widget)new Button((int)(this.field_230708_k_ / 2 + 2), (int)(p_73969_1_ + p_73969_2_ * 2), (int)98, (int)20, (ITextComponent)new TranslationTextComponent((String)"menu.online"), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$createNormalMenuOptions$8(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((TweakedMainMenuScreen)this), (Button.ITooltip)button$itooltip))).field_230693_o_ = flag;
    }

    private void createDemoMenuOptions(int p_73972_1_, int p_73972_2_) {
        boolean flag = this.checkDemoWorldPresence();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, p_73972_1_, 200, 20, (ITextComponent)new TranslationTextComponent("menu.playdemo"), p_213091_2_ -> {
            if (flag) {
                this.field_230706_i_.func_238191_a_("Demo_World");
            } else {
                DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
                this.field_230706_i_.func_238192_a_("Demo_World", MinecraftServer.field_213219_c, dynamicregistries$impl, DimensionGeneratorSettings.func_242752_a((DynamicRegistries)dynamicregistries$impl));
            }
        }));
        this.resetDemoButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, p_73972_1_ + p_73972_2_ * 1, 200, 20, (ITextComponent)new TranslationTextComponent("menu.resetdemo"), p_238658_1_ -> {
            SaveFormat saveformat = this.field_230706_i_.func_71359_d();
            try (SaveFormat.LevelSave saveformat$levelsave = saveformat.func_237274_c_("Demo_World");){
                WorldSummary worldsummary = saveformat$levelsave.func_237296_d_();
                if (worldsummary != null) {
                    this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(this::confirmDemo, (ITextComponent)new TranslationTextComponent("selectWorld.deleteQuestion"), (ITextComponent)new TranslationTextComponent("selectWorld.deleteWarning", new Object[]{worldsummary.func_75788_b()}), (ITextComponent)new TranslationTextComponent("selectWorld.deleteButton"), DialogTexts.field_240633_d_));
                }
            }
            catch (IOException ioexception) {
                SystemToast.func_238535_a_((Minecraft)this.field_230706_i_, (String)"Demo_World");
                LOGGER.warn("Failed to access demo world", (Throwable)ioexception);
            }
        }));
        this.resetDemoButton.field_230693_o_ = flag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDemoWorldPresence() {
        try (SaveFormat.LevelSave saveformat$levelsave = this.field_230706_i_.func_71359_d().func_237274_c_("Demo_World");){
            boolean bl = saveformat$levelsave.func_237296_d_() != null;
            return bl;
        }
        catch (IOException ioexception) {
            SystemToast.func_238535_a_((Minecraft)this.field_230706_i_, (String)"Demo_World");
            LOGGER.warn("Failed to read demo world data", (Throwable)ioexception);
            return false;
        }
    }

    private void realmsButtonClicked() {
        RealmsBridgeScreen realmsbridgescreen = new RealmsBridgeScreen();
        realmsbridgescreen.func_231394_a_((Screen)this);
    }

    protected static void renderMainMenu(TweakedMainMenuScreen gui, MatrixStack mStack, FontRenderer font, int width, int height, int alpha) {
        Object line;
        VersionChecker.Status status = ForgeVersion.getStatus();
        if (status == VersionChecker.Status.BETA || status == VersionChecker.Status.BETA_OUTDATED) {
            line = new TranslationTextComponent("forge.update.beta.1", new Object[]{TextFormatting.RED, TextFormatting.RESET}).func_240699_a_(TextFormatting.RED);
            int n = width / 2;
            font.getClass();
            AbstractGui.func_238472_a_((MatrixStack)mStack, (FontRenderer)font, (ITextComponent)line, (int)n, (int)(4 + 0 * (9 + 1)), (int)(0xFFFFFF | alpha));
            line = new TranslationTextComponent("forge.update.beta.2");
            int n2 = width / 2;
            font.getClass();
            AbstractGui.func_238472_a_((MatrixStack)mStack, (FontRenderer)font, (ITextComponent)line, (int)n2, (int)(4 + 1 * (9 + 1)), (int)(0xFFFFFF | alpha));
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = I18n.func_135052_a((String)"forge.update.newversion", (Object[])new Object[]{ForgeVersion.getTarget()});
                break;
            }
        }
        ForgeHooksClient.forgeStatusLine = line;
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.fadeInStart == 0L && this.fading) {
            this.fadeInStart = Util.func_211177_b();
        }
        float f = this.fading ? (float)(Util.func_211177_b() - this.fadeInStart) / 1000.0f : 1.0f;
        TweakedMainMenuScreen.func_238467_a_((MatrixStack)p_230430_1_, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1);
        this.panorama.func_217623_a(p_230430_4_, MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f));
        int i = 274;
        int j = this.field_230708_k_ / 2 - 137;
        int k = 30;
        this.field_230706_i_.func_110434_K().func_110577_a(PANORAMA_OVERLAY);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fading ? (float)MathHelper.func_76123_f((float)MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f)) : 1.0f));
        TweakedMainMenuScreen.func_238466_a_((MatrixStack)p_230430_1_, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        float f1 = this.fading ? MathHelper.func_76131_a((float)(f - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int l = MathHelper.func_76123_f((float)(f1 * 255.0f)) << 24;
        if ((l & 0xFC000000) != 0) {
            this.field_230706_i_.func_110434_K().func_110577_a(MINECRAFT_LOGO);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            if (this.minceraftEasterEgg) {
                this.func_238459_a_(j, 30, (p_238660_2_, p_238660_3_) -> {
                    this.func_238474_b_(p_230430_1_, p_238660_2_ + 0, (int)p_238660_3_, 0, 0, 99, 44);
                    this.func_238474_b_(p_230430_1_, p_238660_2_ + 99, (int)p_238660_3_, 129, 0, 27, 44);
                    this.func_238474_b_(p_230430_1_, p_238660_2_ + 99 + 26, (int)p_238660_3_, 126, 0, 3, 44);
                    this.func_238474_b_(p_230430_1_, p_238660_2_ + 99 + 26 + 3, (int)p_238660_3_, 99, 0, 26, 44);
                    this.func_238474_b_(p_230430_1_, p_238660_2_ + 155, (int)p_238660_3_, 0, 45, 155, 44);
                });
            } else {
                this.func_238459_a_(j, 30, (p_238657_2_, p_238657_3_) -> {
                    this.func_238474_b_(p_230430_1_, p_238657_2_ + 0, (int)p_238657_3_, 0, 0, 155, 44);
                    this.func_238474_b_(p_230430_1_, p_238657_2_ + 155, (int)p_238657_3_, 0, 45, 155, 44);
                });
            }
            this.field_230706_i_.func_110434_K().func_110577_a(MINECRAFT_EDITION);
            TweakedMainMenuScreen.func_238463_a_((MatrixStack)p_230430_1_, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            TweakedMainMenuScreen.renderMainMenu(this, p_230430_1_, this.field_230712_o_, this.field_230708_k_, this.field_230709_l_, l);
            if (this.splash != null) {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(this.field_230708_k_ / 2 + 90), (float)70.0f, (float)0.0f);
                RenderSystem.rotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                float f2 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Util.func_211177_b() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                f2 = f2 * 100.0f / (float)(this.field_230712_o_.func_78256_a(this.splash) + 32);
                RenderSystem.scalef((float)f2, (float)f2, (float)f2);
                TweakedMainMenuScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)this.splash, (int)0, (int)-8, (int)(0xFFFF00 | l));
                RenderSystem.popMatrix();
            }
            String s = "Minecraft " + SharedConstants.func_215069_a().getName();
            s = this.field_230706_i_.func_71355_q() ? s + " Demo" : s + ("release".equalsIgnoreCase(this.field_230706_i_.func_184123_d()) ? "" : "/" + this.field_230706_i_.func_184123_d());
            if (this.field_230706_i_.func_230151_c_()) {
                s = s + I18n.func_135052_a((String)"menu.modded", (Object[])new Object[0]);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                int n = brdline;
                this.field_230712_o_.getClass();
                TweakedMainMenuScreen.func_238476_c_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)brd, (int)2, (int)(this.field_230709_l_ - (10 + n * (9 + 1))), (int)(0xFFFFFF | l));
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                int n = this.field_230708_k_ - this.field_230712_o_.func_78256_a(brd);
                int n2 = brdline + 1;
                this.field_230712_o_.getClass();
                TweakedMainMenuScreen.func_238476_c_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)brd, (int)n, (int)(this.field_230709_l_ - (10 + n2 * (9 + 1))), (int)(0xFFFFFF | l));
            });
            TweakedMainMenuScreen.func_238476_c_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)"Copyright Mojang AB. Do not distribute!", (int)this.copyrightX, (int)(this.field_230709_l_ - 10), (int)(0xFFFFFF | l));
            if (p_230430_2_ > this.copyrightX && p_230430_2_ < this.copyrightX + this.copyrightWidth && p_230430_3_ > this.field_230709_l_ - 10 && p_230430_3_ < this.field_230709_l_) {
                TweakedMainMenuScreen.func_238467_a_((MatrixStack)p_230430_1_, (int)this.copyrightX, (int)(this.field_230709_l_ - 1), (int)(this.copyrightX + this.copyrightWidth), (int)this.field_230709_l_, (int)(0xFFFFFF | l));
            }
            for (Widget widget : this.field_230710_m_) {
                widget.func_230986_a_(f1);
            }
            super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
            if (this.realmsNotificationsEnabled() && f1 >= 1.0f) {
                this.realmsNotificationsScreen.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
            }
            this.modUpdateNotification.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_)) {
            return true;
        }
        if (this.realmsNotificationsEnabled() && this.realmsNotificationsScreen.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_)) {
            return true;
        }
        if (p_231044_1_ > (double)this.copyrightX && p_231044_1_ < (double)(this.copyrightX + this.copyrightWidth) && p_231044_3_ > (double)(this.field_230709_l_ - 10) && p_231044_3_ < (double)this.field_230709_l_) {
            this.field_230706_i_.func_147108_a((Screen)new WinGameScreen(false, Runnables.doNothing()));
        }
        return false;
    }

    public void func_231164_f_() {
        if (this.realmsNotificationsScreen != null) {
            this.realmsNotificationsScreen.func_231164_f_();
        }
    }

    private void confirmDemo(boolean p_213087_1_) {
        if (p_213087_1_) {
            try (SaveFormat.LevelSave saveformat$levelsave = this.field_230706_i_.func_71359_d().func_237274_c_("Demo_World");){
                saveformat$levelsave.func_237299_g_();
            }
            catch (IOException ioexception) {
                SystemToast.func_238538_b_((Minecraft)this.field_230706_i_, (String)"Demo_World");
                LOGGER.warn("Failed to delete demo world", (Throwable)ioexception);
            }
        }
        this.field_230706_i_.func_147108_a((Screen)this);
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$8(Button p_238661_1_) {
        this.realmsButtonClicked();
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$7(Button p_213095_1_) {
        MultiplayerScreen screen = this.field_230706_i_.field_71474_y.field_230152_Z_ ? new MultiplayerScreen((Screen)this) : new MultiplayerWarningScreen((Screen)this);
        this.field_230706_i_.func_147108_a((Screen)screen);
    }
}

