/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers.screens;

import dev.falsegamemaster.ihatecores.registration.containers.ContainerMap;
import dev.falsegamemaster.ihatecores.registration.containers.IGenericContainer;
import dev.falsegamemaster.ihatecores.registration.packets.OpenContainerPacket;
import dev.falsegamemaster.ihatecores.registration.packets.PacketMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;

public class ScreenOpener {
    public static void open(Screen screen) {
        Minecraft.func_71410_x().func_147108_a(screen);
    }

    public static void close() {
        ScreenOpener.open(null);
    }

    public static class Container {
        protected final ContainerMap containers;
        protected final PacketMap packets;

        public static Container of(ContainerMap containerMap, PacketMap packetMap) {
            return new Container(containerMap, packetMap);
        }

        public static INamedContainerProvider getProvider(ContainerType<?> containerType, ITextComponent name, World world, BlockPos pos) {
            return new SimpleNamedContainerProvider((id, playerInventory, player) -> {
                net.minecraft.inventory.container.Container c = containerType.func_221506_a(id, playerInventory);
                if (c instanceof IGenericContainer) {
                    ((IGenericContainer)c).setAccess(IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos));
                }
                return c;
            }, name);
        }

        protected Container(ContainerMap containers, PacketMap packets) {
            this.containers = containers;
            this.packets = packets;
        }

        public boolean open(PlayerEntity player, Object inventory) {
            return this.open(player, inventory, (CompoundNBT data) -> {});
        }

        public boolean open(PlayerEntity player, Object inventory, Consumer<CompoundNBT> data) {
            if (!(player instanceof ServerPlayerEntity) || !(inventory instanceof INamedContainerProvider)) {
                return false;
            }
            return this.open((ServerPlayerEntity)player, (INamedContainerProvider)inventory, data);
        }

        public boolean open(ServerPlayerEntity player, INamedContainerProvider inventory, Consumer<CompoundNBT> data) {
            if (player.field_70170_p.field_72995_K) {
                return false;
            }
            player.func_71128_l();
            player.func_71117_bO();
            int openContainerId = player.field_71139_cq;
            CompoundNBT extraData = new CompoundNBT();
            data.accept(extraData);
            net.minecraft.inventory.container.Container container = inventory.createMenu(openContainerId, player.field_71071_by, (PlayerEntity)player);
            if (container == null) {
                return false;
            }
            ContainerType type = container.func_216957_a();
            OpenContainerPacket msg = new OpenContainerPacket(type, openContainerId, inventory.func_145748_c_(), extraData);
            this.packets.getChannel().sendTo((Object)msg, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            player.field_71070_bA = container;
            player.field_71070_bA.func_75132_a((IContainerListener)player);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)player, container));
            return true;
        }

        @Deprecated
        protected static <I extends IInventory & INamedContainerProvider> boolean openOnServerOnly(ServerPlayerEntity serverPlayer, I inventory, net.minecraft.inventory.container.Container container) {
            if (container == null) {
                return false;
            }
            serverPlayer.field_71070_bA = container;
            serverPlayer.field_71070_bA.func_75132_a((IContainerListener)serverPlayer);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)serverPlayer, container));
            return true;
        }

        @Deprecated
        public static <I extends IInventory & INamedContainerProvider> boolean openOnServerOnly(ServerPlayerEntity serverPlayer, I inventory) {
            serverPlayer.func_71128_l();
            serverPlayer.func_71117_bO();
            int containerId = serverPlayer.field_71139_cq;
            net.minecraft.inventory.container.Container container = ((IContainerProvider)inventory).createMenu(containerId, serverPlayer.field_71071_by, (PlayerEntity)serverPlayer);
            return Container.openOnServerOnly(serverPlayer, inventory, container);
        }
    }
}

