/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.falsegamemaster.ihatecores.registration.containers.IRecipeContainer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class GenericContainerScreen<C extends Container>
extends ContainerScreen<C> {
    protected final String modid;
    protected final String name;

    public GenericContainerScreen(String modid, String name, C container, PlayerInventory playerInv, ITextComponent title) {
        super(container, playerInv, title);
        this.modid = modid;
        this.name = name;
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    protected void func_230450_a_(@Nonnull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        if (this.field_230706_i_ == null) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation(this.modid, "textures/gui/container/" + this.name + ".png"));
        Regions regions = new Regions();
        this.addRegionsToRender(regions);
        regions.forEach(r -> this.func_238474_b_(stack, r.x, r.y, r.offsetX, r.offsetY, r.width, r.height));
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double sensitivity) {
        this.scrollRecipeResult(sensitivity);
        return super.func_231043_a_(mouseX, mouseY, sensitivity);
    }

    protected void scrollRecipeResult(double sensitivity) {
        if (!(this.field_147002_h instanceof IRecipeContainer)) {
            return;
        }
        IRecipeContainer recipeMenu = (IRecipeContainer)this.field_147002_h;
        if (this.field_147006_u == null || this.field_147006_u.getSlotIndex() != recipeMenu.getResultSlot().getSlotIndex()) {
            return;
        }
        int increment = sensitivity < 0.0 ? 1 : -1;
        recipeMenu.setSelectedRecipe(recipeMenu.getSelectedRecipe() + increment);
        recipeMenu.craftRecipe();
    }

    public final void addDefaultRegionsToRender(Regions regions) {
        regions.add(this.getGuiLeft(), this.getGuiTop(), this.getXSize(), this.getYSize(), 0, 0);
    }

    protected void addRegionsToRender(Regions regions) {
        this.addDefaultRegionsToRender(regions);
    }

    protected void func_230451_b_(@Nonnull MatrixStack stack, int p_230451_2_, int p_230451_3_) {
        Labels labels = new Labels();
        this.addLabelsToRender(labels);
        labels.forEach(l -> this.field_230712_o_.func_243248_b(stack, l.text, (float)l.x, (float)l.y, l.color.getRGB()));
    }

    public final void addDefaultLabelsToRender(Labels labels) {
        labels.add(this.field_230704_d_, this.field_238742_p_, this.field_238743_q_, Color.DARK_GRAY);
        labels.add(this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, Color.DARK_GRAY);
    }

    protected void addLabelsToRender(Labels labels) {
        this.addDefaultLabelsToRender(labels);
    }

    public String getModid() {
        return this.modid;
    }

    public String getName() {
        return this.name;
    }

    public int getTitleX() {
        return this.field_238742_p_;
    }

    public int getTitleY() {
        return this.field_238743_q_;
    }

    public PlayerInventory getInventory() {
        return this.field_213127_e;
    }

    public int getInventoryX() {
        return this.field_238744_r_;
    }

    public int getInventoryY() {
        return this.field_238745_s_;
    }

    public static class Labels
    implements Iterable<Label> {
        private final List<Label> labels = new ArrayList<Label>();

        @Override
        public Iterator<Label> iterator() {
            return this.labels.iterator();
        }

        public void add(Label label) {
            this.labels.add(label);
        }

        public void add(ITextComponent text, int x, int y, Color color) {
            this.add(new Label(text, x, y, color));
        }
    }

    public static class Label {
        public ITextComponent text;
        public int x;
        public int y;
        public Color color;

        public Label(ITextComponent text, int x, int y, Color color) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.color = color;
        }
    }

    public static class Regions
    implements Iterable<Region> {
        private final List<Region> regions = new ArrayList<Region>();

        @Override
        public Iterator<Region> iterator() {
            return this.regions.iterator();
        }

        public void add(Region region) {
            this.regions.add(region);
        }

        public void add(int x, int y, int width, int height, int offsetX, int offsetY) {
            this.add(new Region(x, y, width, height, offsetX, offsetY));
        }
    }

    public static class Region {
        public int x;
        public int y;
        public int width;
        public int height;
        public int offsetX;
        public int offsetY;

        public Region(int x, int y, int width, int height, int offsetX, int offsetY) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }
}

