/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers;

import dev.falsegamemaster.ihatecores.registration.containers.inventory.IHasDrops;
import dev.falsegamemaster.ihatecores.registration.recipes.CraftingResult;
import dev.falsegamemaster.ihatecores.registration.recipes.CustomIngredient;
import dev.falsegamemaster.ihatecores.registration.recipes.INbtRecipe;
import dev.falsegamemaster.ihatecores.registration.recipes.IngredientData;
import dev.falsegamemaster.ihatecores.registration.recipes.IngredientList;
import dev.falsegamemaster.ihatecores.util.nbt.FormattedCompoundNBT;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.world.World;

public interface IRecipeContainer<R extends IRecipe<I>, I extends IInventory>
extends IHasDrops {
    public static <R extends IRecipe<I>, I extends IInventory> List<R> getAllRecipes(IRecipeType<R> type, World world) {
        return world.func_199532_z().func_241447_a_(type);
    }

    public static <R extends IRecipe<I>, I extends IInventory> List<R> getRecipes(IRecipeType<R> type, World world, Predicate<R> matches) {
        return world.func_199532_z().func_241447_a_(type).stream().filter(matches).collect(Collectors.toList());
    }

    public static <R extends IRecipe<I>, I extends IInventory> boolean matchesShapedRecipe(R recipe, List<? extends Slot> slots) {
        IngredientList<CustomIngredient> ingredients = IngredientData.filterIngredients((List<Ingredient>)recipe.func_192400_c());
        ingredients = ingredients.matchSize(slots.size(), IngredientData.empty().toIngredient());
        boolean matches = true;
        for (int i = 0; i < slots.size(); ++i) {
            if (ingredients.get(i).test(slots.get(i).func_75211_c())) continue;
            matches = false;
            break;
        }
        return matches;
    }

    public static <R extends IRecipe<I>, I extends IInventory> boolean matchesShapelessRecipe(R recipe, List<? extends Slot> slots) {
        IngredientList<CustomIngredient> ingredients = IngredientData.filterIngredients((List<Ingredient>)recipe.func_192400_c());
        ingredients = ingredients.matchSize(slots.size(), IngredientData.empty().toIngredient());
        slots = new ArrayList<Slot>(slots);
        boolean ingredientsMatch = true;
        Iterator iterator = ingredients.iterator();
        while (iterator.hasNext()) {
            CustomIngredient ingredient = (CustomIngredient)((Object)iterator.next());
            boolean ingredientMatches = false;
            for (int j = 0; j < slots.size(); ++j) {
                if (!ingredient.test(slots.get(j).func_75211_c())) continue;
                ingredientMatches = true;
                slots.remove(j);
                break;
            }
            if (ingredientMatches) continue;
            ingredientsMatch = false;
            break;
        }
        return ingredientsMatch;
    }

    public List<? extends Slot> getIngredientSlots();

    public Slot getResultSlot();

    default public boolean matchesRecipe(R recipe) {
        List<Slot> slots = this.getIngredientSlots();
        Optional<CompoundNBT> data = INbtRecipe.tryGet(recipe).map(INbtRecipe::getData);
        if (data.isPresent()) {
            Function<String, String> formatter = key -> key.toLowerCase().replace("_", "");
            FormattedCompoundNBT formatted = FormattedCompoundNBT.format(data.get(), formatter);
            switch (formatted.func_74779_i("subtype")) {
                case "shaped": {
                    return IRecipeContainer.matchesShapedRecipe(recipe, slots);
                }
                case "shapeless": {
                    return IRecipeContainer.matchesShapelessRecipe(recipe, slots);
                }
            }
        }
        return IRecipeContainer.matchesShapedRecipe(recipe, slots);
    }

    public ItemStack assembleRecipe(R var1);

    default public List<R> getRecipes() {
        return IRecipeContainer.getRecipes(this.getRecipeType(), this.getPlayer().field_70170_p, this::matchesRecipe);
    }

    default public CraftingResult craftRecipe(@Nullable R recipe) {
        this.setItemInSlot(this.getResultSlot(), recipe == null ? ItemStack.field_190927_a : this.assembleRecipe(recipe));
        if (recipe == null) {
            return CraftingResult.failure();
        }
        IngredientList<CustomIngredient> ingredients = IngredientData.filterIngredients((List<Ingredient>)recipe.func_192400_c());
        List<Slot> ingredientSlots = this.getIngredientSlots();
        ArrayList<CraftingResult.RemainderInfo> remainders = new ArrayList<CraftingResult.RemainderInfo>();
        for (int i = 0; i < ingredients.size() && i < ingredientSlots.size(); ++i) {
            remainders.add(ingredients.get(i).craft(ingredientSlots.get(i).func_75211_c()));
        }
        return CraftingResult.success(remainders);
    }

    default public CraftingResult craftRecipe() {
        List<R> recipes = this.getRecipes();
        int size = recipes.size();
        if (size == 0) {
            return CraftingResult.failure();
        }
        this.setSelectedRecipe(this.validateSelectedRecipe(this.getSelectedRecipe(), size));
        int index = this.getSelectedRecipe();
        return this.craftRecipe((IRecipe)recipes.get(index));
    }

    public IRecipeType<R> getRecipeType();

    public int getSelectedRecipe();

    public void setSelectedRecipe(int var1);

    default public int validateSelectedRecipe(int index, int size) {
        return index < 0 ? size - 1 - Math.abs(index - size + 1) % size : Math.abs(index) % size;
    }

    public PlayerEntity getPlayer();

    default public void setItemInSlot(Slot slot, ItemStack stack) {
        PlayerEntity player = this.getPlayer();
        int index = slot.getSlotIndex();
        if (player instanceof ServerPlayerEntity && index >= 0) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(player.field_71070_bA.field_75152_c, index, stack));
        }
        slot.field_75224_c.func_70299_a(index, stack);
    }
}

