/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers;

import dev.falsegamemaster.ihatecores.registration.containers.inventory.FakeInventory;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.FakePlayerInventory;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.IFakeInventory;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.IHasWorldPos;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.IResizableInventory;
import dev.falsegamemaster.ihatecores.registration.containers.slots.SimpleSlot;
import dev.falsegamemaster.ihatecores.util.TypePreservingMap;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;

public interface IGenericContainer<I extends IInventory>
extends IHasWorldPos {
    public PlayerEntity getPlayer();

    public PacketBuffer getData();

    public I getInventory();

    public int getSize2();

    public List<Slot> getSlots();

    public TypePreservingMap<String, Slot> getSlotMap();

    public List<Runnable> getPutSlotsQueue();

    @Override
    default public IWorldPosCallable getAccess() {
        return IWorldPosCallable.field_221489_a;
    }

    public void setPlayer(PlayerEntity var1);

    public void setData(PacketBuffer var1);

    public void setInventory(I var1);

    public void setSize(int var1);

    @Override
    default public void setAccess(IWorldPosCallable access) {
    }

    default public void init(PlayerInventory playerInventory, I inventory, PacketBuffer data) {
        this.setPlayer(playerInventory.field_70458_d);
        this.setInventory(inventory);
        this.setData(data);
        this.countSlots();
        if (inventory instanceof IResizableInventory && inventory.func_70302_i_() != this.getSize2()) {
            ((IResizableInventory)inventory).setSize(this.getSize2());
        }
        this.putSlotsInternal((IInventory)inventory, playerInventory);
    }

    default public <S extends Slot> S getSlot(String name) {
        return (S)((Slot)this.getSlotMap().get(name));
    }

    @Deprecated
    public Slot addSlot2(@Nullable Slot var1);

    default public <S extends Slot> S putSlot(S slot, boolean putName) {
        this.getPutSlotsQueue().add(() -> {
            if (slot.field_75224_c instanceof IFakeInventory) {
                this.setSize(this.getSize2() + 1);
                return;
            }
            if (putName) {
                this.getSlotMap().put(String.valueOf(slot.getSlotIndex()), slot);
            }
            if (slot instanceof SimpleSlot && slot.getSlotIndex() == -1) {
                ((SimpleSlot)slot).setSlot(this.getSlots().size());
            }
            this.addSlot2(slot);
        });
        return slot;
    }

    default public <S extends Slot> S putSlot(S slot) {
        return this.putSlot(slot, true);
    }

    default public <S extends Slot> S putSlot(String name, S slot) {
        if (slot.field_75224_c != null) {
            this.getSlotMap().put(name, slot);
        }
        return this.putSlot(slot, false);
    }

    default public void countSlots() {
        this.putSlotsInternal((IInventory)new FakeInventory(), new FakePlayerInventory());
    }

    default public void putSlotsInternal(IInventory inv, PlayerInventory playerInv) {
        if (this.hasPlayerInventory()) {
            this.putPlayerInventorySlots(playerInv, this.getPlayerInventoryOffset());
        }
        this.putSlots(inv, playerInv);
        this.getPutSlotsQueue().forEach(Runnable::run);
    }

    default public void putPlayerInventorySlots(PlayerInventory playerInv, Point offset) {
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 9; ++i) {
                int slot = j * 9 + i + 9;
                this.putSlot(new Slot((IInventory)playerInv, slot, i * 18 + offset.x, j * 18 + offset.y));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.putSlot(new Slot((IInventory)playerInv, k, k * 18 + offset.x, offset.y + 58));
        }
    }

    default public boolean hasPlayerInventory() {
        return true;
    }

    default public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    public boolean moveItemStackTo2(ItemStack var1, int var2, int var3, boolean var4);

    default public ItemStack quickMoveStack2(@Nonnull PlayerEntity player, int index) {
        if (!this.hasPlayerInventory()) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.getSlots().get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack copyStack = stack.func_77946_l();
        boolean hasShiftDown = player.func_225608_bj_();
        if (!hasShiftDown) {
            slot.func_190901_a(player, stack);
        }
        if (index < 36 && !this.moveItemStackTo2(stack, 36, this.getSlots().size(), this.getContainerInventoryFillOrder().get())) {
            return ItemStack.field_190927_a;
        }
        if (!this.moveItemStackTo2(stack, 0, 36, this.getPlayerInventoryFillOrder().get())) {
            return ItemStack.field_190927_a;
        }
        if (hasShiftDown) {
            slot.func_75220_a(stack, copyStack);
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return copyStack;
    }

    public void putSlots(IInventory var1, PlayerInventory var2);

    default public FillOrder getContainerInventoryFillOrder() {
        return FillOrder.LEFT_TO_RIGHT_TOP_TO_BOTTOM;
    }

    default public FillOrder getPlayerInventoryFillOrder() {
        return FillOrder.RIGHT_TO_LEFT_BOTTOM_TO_TOP;
    }

    public static enum FillOrder {
        LEFT_TO_RIGHT_TOP_TO_BOTTOM(false),
        RIGHT_TO_LEFT_BOTTOM_TO_TOP(true);

        private final boolean order;

        private FillOrder(boolean order) {
            this.order = order;
        }

        public boolean get() {
            return this.order;
        }
    }
}

