/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers;

import dev.falsegamemaster.ihatecores.registration.containers.IGenericContainer;
import dev.falsegamemaster.ihatecores.registration.containers.IRecipeContainer;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.TypePreservingMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;

public abstract class GenericRecipeContainer<I extends IInventory & IRecipeHelperPopulator, R extends IRecipe<I>>
extends RecipeBookContainer<I>
implements IGenericContainer<I>,
IRecipeContainer<R, I> {
    protected PlayerEntity player;
    protected I inventory;
    protected PacketBuffer data;
    protected int size = 0;
    protected int selectedRecipe = 0;
    protected final TypePreservingMap<String, Slot> slotMap = new TypePreservingMap();
    protected final List<Runnable> putSlotsQueue = new ArrayList<Runnable>();
    protected IWorldPosCallable access = IWorldPosCallable.field_221489_a;
    protected final IRecipeType<R> recipeType;

    public GenericRecipeContainer(ContainerType<?> containerType, IRecipeType<?> recipeType, int id, PlayerInventory playerInventory, IInventory inventory, PacketBuffer data) {
        super(containerType, id);
        IInventory i = (IInventory)GenericsUtil.castOrNull(inventory);
        this.init(playerInventory, i, data);
        this.player = playerInventory.field_70458_d;
        this.inventory = i;
        this.data = data;
        this.recipeType = (IRecipeType)GenericsUtil.castOrNull(recipeType);
    }

    @Override
    public IRecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    @Override
    public void putSlots(IInventory inv, PlayerInventory playerInv) {
        this.putSlots(this.recipeType, inv, playerInv);
    }

    public abstract void putSlots(IRecipeType<?> var1, IInventory var2, PlayerInventory var3);

    @Override
    public int getSelectedRecipe() {
        return this.selectedRecipe;
    }

    @Override
    public void setSelectedRecipe(int index) {
        this.selectedRecipe = index;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    @Nullable
    public I getInventory() {
        return this.inventory;
    }

    @Override
    public PacketBuffer getData() {
        return this.data;
    }

    @Override
    public List<Slot> getSlots() {
        return this.field_75151_b;
    }

    @Override
    public TypePreservingMap<String, Slot> getSlotMap() {
        return this.slotMap;
    }

    @Override
    public List<Runnable> getPutSlotsQueue() {
        return this.putSlotsQueue;
    }

    @Override
    public IWorldPosCallable getAccess() {
        return this.access;
    }

    @Override
    public void setPlayer(PlayerEntity player) {
        this.player = player;
    }

    @Override
    public void setData(PacketBuffer data) {
        this.data = data;
    }

    @Override
    public void setInventory(I inventory) {
        this.inventory = inventory;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void setAccess(IWorldPosCallable access) {
        this.access = access;
    }

    public Slot func_75146_a(@Nullable Slot slot) {
        if (slot == null) {
            return null;
        }
        return super.func_75146_a(slot);
    }

    @Override
    public Slot addSlot2(@Nullable Slot slot) {
        if (slot == null) {
            return null;
        }
        return super.func_75146_a(slot);
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (this.inventory == null) {
            return false;
        }
        return this.inventory.func_70300_a(player);
    }

    public boolean func_75135_a(ItemStack stack, int slot, int containerSize, boolean fillOrder) {
        return super.func_75135_a(stack, slot, containerSize, fillOrder);
    }

    @Override
    public boolean moveItemStackTo2(ItemStack stack, int slot, int containerSize, boolean fillOrder) {
        return super.func_75135_a(stack, slot, containerSize, fillOrder);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return IGenericContainer.super.quickMoveStack2(player, index);
    }

    public ItemStack func_184996_a(int p_184996_1_, int p_184996_2_, ClickType p_184996_3_, PlayerEntity p_184996_4_) {
        return super.func_184996_a(p_184996_1_, p_184996_2_, p_184996_3_, p_184996_4_);
    }

    public void func_201771_a(@Nonnull RecipeItemHelper helper) {
        if (this.inventory == null) {
            return;
        }
        ((IRecipeHelperPopulator)this.inventory).func_194018_a(helper);
    }

    public void func_201768_e() {
        if (this.inventory == null) {
            return;
        }
        this.inventory.func_174888_l();
    }

    public boolean func_201769_a(IRecipe<? super I> recipe) {
        if (this.inventory == null) {
            return false;
        }
        return recipe.func_77569_a(this.inventory, this.player.field_70170_p);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.access.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, (IInventory)this.inventory));
    }

    public int func_201767_f() {
        return this.getResultSlot().getSlotIndex();
    }

    public int func_201770_g() {
        return 0;
    }

    public int func_201772_h() {
        return 0;
    }

    public int func_203721_h() {
        return this.size;
    }

    @Override
    public int getSize2() {
        return this.size;
    }

    public RecipeBookCategory func_241850_m() {
        return null;
    }
}

