/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers;

import dev.falsegamemaster.ihatecores.registration.containers.IGenericContainer;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.TypePreservingMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class GenericContainer<I extends IInventory>
extends Container
implements IGenericContainer<I> {
    protected PlayerEntity player;
    protected I inventory;
    protected PacketBuffer data;
    protected int size = 0;
    protected final TypePreservingMap<String, Slot> slotMap = new TypePreservingMap();
    protected final List<Runnable> putSlotsQueue = new ArrayList<Runnable>();
    protected IWorldPosCallable access = IWorldPosCallable.field_221489_a;

    public GenericContainer(ContainerType<?> containerType, int id, PlayerInventory playerInventory, IInventory inventory, PacketBuffer data) {
        super(containerType, id);
        IInventory i = (IInventory)GenericsUtil.castOrNull(inventory);
        this.init(playerInventory, i, data);
        this.player = playerInventory.field_70458_d;
        this.inventory = i;
        this.data = data;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    @Nullable
    public I getInventory() {
        return this.inventory;
    }

    @Override
    public PacketBuffer getData() {
        return this.data;
    }

    @Override
    public List<Slot> getSlots() {
        return this.field_75151_b;
    }

    @Override
    public TypePreservingMap<String, Slot> getSlotMap() {
        return this.slotMap;
    }

    @Override
    public List<Runnable> getPutSlotsQueue() {
        return this.putSlotsQueue;
    }

    @Override
    public IWorldPosCallable getAccess() {
        return this.access;
    }

    @Override
    public void setPlayer(PlayerEntity player) {
        this.player = player;
    }

    @Override
    public void setData(PacketBuffer data) {
        this.data = data;
    }

    @Override
    public void setInventory(I inventory) {
        this.inventory = inventory;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void setAccess(IWorldPosCallable access) {
        this.access = access;
    }

    public Slot func_75146_a(@Nullable Slot slot) {
        if (slot == null) {
            return null;
        }
        return super.func_75146_a(slot);
    }

    @Override
    public Slot addSlot2(@Nullable Slot slot) {
        if (slot == null) {
            return null;
        }
        return super.func_75146_a(slot);
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (this.inventory == null) {
            return false;
        }
        return this.inventory.func_70300_a(player);
    }

    public boolean func_75135_a(ItemStack stack, int slot, int containerSize, boolean fillOrder) {
        return super.func_75135_a(stack, slot, containerSize, fillOrder);
    }

    @Override
    public boolean moveItemStackTo2(ItemStack stack, int slot, int containerSize, boolean fillOrder) {
        return super.func_75135_a(stack, slot, containerSize, fillOrder);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return IGenericContainer.super.quickMoveStack2(player, index);
    }

    public ItemStack func_184996_a(int p_184996_1_, int p_184996_2_, ClickType p_184996_3_, PlayerEntity p_184996_4_) {
        return super.func_184996_a(p_184996_1_, p_184996_2_, p_184996_3_, p_184996_4_);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.access.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, (IInventory)this.inventory));
    }

    @Override
    public int getSize2() {
        return this.size;
    }
}

