/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.containers;

import dev.falsegamemaster.ihatecores.api.ForgeRegistryMap;
import dev.falsegamemaster.ihatecores.registration.containers.SimpleContainerType;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.ResizableInventory;
import dev.falsegamemaster.ihatecores.registration.events.ScreenRegistry;
import dev.falsegamemaster.ihatecores.registration.recipes.RecipeMap;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.TypePreservingMap;
import dev.falsegamemaster.ihatecores.util.data_structures.TriFunction;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.DistExecutor;

public class ContainerMap
extends ForgeRegistryMap<ContainerType<?>> {
    protected final TypePreservingMap<ContainerType<?>, TriFunction<Container, PlayerInventory, ITextComponent, Screen>> screens = new TypePreservingMap();
    protected final RecipeMap recipes;

    public ContainerMap(RecipeMap recipes) {
        super(ContainerType.class);
        this.recipes = recipes;
        ScreenRegistry.addContainerMap(this);
    }

    protected <C extends Container, S extends Screen> void tryPutScreen(String name, ContainerType<?> type, Supplier<ScreenFactory<C, S>> screen) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.lambda$null$1(type, (Supplier)screen, name));
    }

    public <C extends Container> ContainerType<? extends C> putNoScreen(String name, SimpleContainerFactory<C> container) {
        ContainerType type = IForgeContainerType.create(container::create);
        super.put(name, type);
        return type;
    }

    public <C extends Container> ContainerType<? extends C> putNoScreen(String name, ContainerFactory<C> container) {
        ContainerType<Container> type = SimpleContainerType.of((t, id, inv, buf) -> container.create(t, id, inv, (IInventory)new ResizableInventory(new ItemStack[0]), buf));
        super.put(name, type);
        return type;
    }

    public <C extends Container, S extends Screen> ContainerType<? extends C> put(String name, ContainerFactory<C> container, Supplier<ScreenFactory<C, S>> screen) {
        ContainerType<C> type = this.putNoScreen(name, container);
        this.tryPutScreen(name, type, screen);
        return type;
    }

    public <C extends Container, S extends Screen> ContainerType<? extends C> put(String name, String recipeName, RecipeContainerFactory<C> recipeContainer, Supplier<ScreenFactory<C, S>> screen) {
        ContainerFactory<Container> container = (a, b, c, d, e) -> recipeContainer.create(a, this.recipes.getType(recipeName), b, c, d, e);
        ContainerType<Container> type = this.putNoScreen(name, container);
        this.tryPutScreen(name, type, screen);
        return type;
    }

    public <C extends Container, S extends Screen> Optional<S> getScreen(C container, PlayerInventory playerInventory, ITextComponent name) {
        return GenericsUtil.tryCast(((TriFunction)this.screens.get(container.func_216957_a())).apply(container, playerInventory, name));
    }

    public boolean hasScreen(ContainerType<?> type) {
        return this.screens.containsKey(type);
    }

    public TypePreservingMap<ContainerType<?>, TriFunction<Container, PlayerInventory, ITextComponent, Screen>> getScreens() {
        return new TypePreservingMap(this.screens::get);
    }

    private /* synthetic */ void lambda$null$1(ContainerType type, Supplier screen, String name) {
        this.screens.put(type, (arg_0, arg_1, arg_2) -> this.lambda$null$0((Supplier)screen, name, arg_0, arg_1, arg_2));
    }

    private /* synthetic */ Screen lambda$null$0(Supplier screen, String name, Container c, PlayerInventory i, ITextComponent t) {
        return ((ScreenFactory)screen.get()).create(this.modid, name, (Container)GenericsUtil.castOrNull(c), i, t);
    }

    public static interface ScreenFactory<C extends Container, S extends Screen> {
        public S create(String var1, String var2, C var3, PlayerInventory var4, ITextComponent var5);
    }

    public static interface RecipeContainerFactory<C extends Container> {
        public C create(ContainerType<?> var1, IRecipeType<?> var2, int var3, PlayerInventory var4, IInventory var5, PacketBuffer var6);
    }

    public static interface SimpleContainerFactory<C extends Container> {
        public C create(int var1, PlayerInventory var2, PacketBuffer var3);
    }

    public static interface ContainerFactory<C extends Container> {
        public C create(ContainerType<?> var1, int var2, PlayerInventory var3, IInventory var4, PacketBuffer var5);
    }
}

