/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.config;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public abstract class Config {
    protected final ModConfig.Type type;
    protected final ForgeConfigSpec.Builder builder;
    public ForgeConfigSpec builtConfig = null;
    protected final HashMap<String, ForgeConfigSpec.ConfigValue<?>> map = new LinkedHashMap();

    public Config(ModConfig.Type type) {
        this.type = type;
        this.builder = new ForgeConfigSpec.Builder();
    }

    public ModConfig.Type getType() {
        return this.type;
    }

    public ForgeConfigSpec.Builder getBuilder() {
        return this.builder;
    }

    public Config startSection(String text) {
        this.builder.push(text);
        return this;
    }

    public Config endSection() {
        this.builder.pop();
        return this;
    }

    public Config comment(String text) {
        this.builder.comment(" " + text);
        return this;
    }

    public Config newLine() {
        this.comment("");
        return this;
    }

    public <V> Config add(String name, V value) {
        this.map.put(name, this.builder.define(name, value));
        return this;
    }

    @SafeVarargs
    public final <V> Config add(String name, V ... values) {
        if (values.length == 0) {
            return this.add(name, (V)"[]");
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(values[i]);
        }
        return this.add(name, (V)stringBuilder.append("]").toString());
    }

    public <V> Config add(String name, List<V> values) {
        return this.add(name, values.toArray(new Object[0]));
    }

    public <K, V> Config add(String name, Map<K, V> map) {
        int size = map.size();
        if (size == 0) {
            return this.add(name, (V)"{}");
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        List entries = map.entrySet().stream().map(entry -> entry.getKey() + "->" + entry.getValue()).collect(Collectors.toList());
        stringBuilder.append((String)entries.get(0));
        for (int i = 1; i < size; ++i) {
            stringBuilder.append(",");
            stringBuilder.append((String)entries.get(i));
        }
        return this.add(name, (V)stringBuilder.append("}").toString());
    }

    public <V> Optional<V> get(String name, Class<V> clazz) {
        Object value = this.map.get(name).get();
        if (value != null && clazz.isAssignableFrom(value.getClass())) {
            return Optional.of(clazz.cast(value));
        }
        return Optional.empty();
    }

    public boolean getBoolean(String name) {
        return this.get(name, Boolean.class).orElse(false);
    }

    public short getShort(String name) {
        return this.get(name, Short.class).orElse((short)0);
    }

    public int getInt(String name) {
        return this.get(name, Integer.class).orElse(0);
    }

    public long getLong(String name) {
        return this.get(name, Long.class).orElse(0L);
    }

    public float getFloat(String name) {
        return this.get(name, Float.class).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public double getDouble(String name) {
        return this.get(name, Double.class).orElse(0.0);
    }

    public char getChar(String name) {
        return this.get(name, Character.class).orElse(Character.valueOf(' ')).charValue();
    }

    public String getString(String name) {
        return this.get(name, String.class).orElse("");
    }

    protected String formatCollection(String collection) {
        String noBrackets = collection.substring(1, collection.length() - 1);
        String noSpaces = noBrackets.replace(" ", "");
        return noSpaces.toLowerCase();
    }

    public <V> List<V> getList(String name, Function<String, V> decoder) {
        String listAsString = this.formatCollection(this.getString(name));
        List<String> valuesAsStrings = Arrays.asList(listAsString.split(","));
        return valuesAsStrings.stream().map(decoder).collect(Collectors.toList());
    }

    public <V> V[] getArray(String name, Function<String, V> decoder, IntFunction<V[]> generator) {
        return this.getList(name, decoder).toArray(generator.apply(0));
    }

    public <K, V> Map<K, V> getMap(String name, BiFunction<String, String, Pair<K, V>> decoder) {
        String mapAsString = this.formatCollection(this.getString(name));
        List<String> entriesAsStrings = Arrays.asList(mapAsString.split(","));
        List<Pair> pairs = entriesAsStrings.stream().map(entry -> {
            String[] pair = entry.split("->");
            return (Pair)decoder.apply(pair[0], pair[1]);
        }).collect(Collectors.toList());
        LinkedHashMap map = new LinkedHashMap();
        pairs.forEach(pair -> map.put(pair.getFirst(), pair.getSecond()));
        return map;
    }

    public ForgeConfigSpec build() {
        this.builtConfig = this.builder.build();
        return this.builtConfig;
    }

    public boolean isLoaded() {
        return this.builtConfig != null && this.builtConfig.isLoaded();
    }

    public static class Common
    extends Config {
        public Common() {
            super(ModConfig.Type.COMMON);
        }
    }

    public static class Server
    extends Config {
        public Server() {
            super(ModConfig.Type.SERVER);
        }
    }

    public static class Client
    extends Config {
        public Client() {
            super(ModConfig.Type.CLIENT);
        }
    }
}

