/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;

public class MaterialBuilder {
    private PushReaction pushReaction = PushReaction.NORMAL;
    private boolean blocksMotion = true;
    private boolean flammable;
    private boolean liquid;
    private boolean replaceable;
    private boolean solid = true;
    private MaterialColor color;
    private boolean solidBlocking = true;

    public static MaterialBuilder create() {
        return new MaterialBuilder();
    }

    private MaterialBuilder() {
    }

    public MaterialBuilder liquid() {
        this.liquid = true;
        return this;
    }

    public MaterialBuilder nonSolid() {
        this.solid = false;
        return this;
    }

    public MaterialBuilder noCollider() {
        this.blocksMotion = false;
        return this;
    }

    public MaterialBuilder notSolidBlocking() {
        this.solidBlocking = false;
        return this;
    }

    public MaterialBuilder flammable() {
        this.flammable = true;
        return this;
    }

    public MaterialBuilder replaceable() {
        this.replaceable = true;
        return this;
    }

    public MaterialBuilder destroyOnPush() {
        this.pushReaction = PushReaction.DESTROY;
        return this;
    }

    public MaterialBuilder notPushable() {
        this.pushReaction = PushReaction.BLOCK;
        return this;
    }

    public Material build() {
        return new Material(this.color, this.liquid, this.solid, this.blocksMotion, this.solidBlocking, this.flammable, this.replaceable, this.pushReaction);
    }
}

