/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.blocks;

import dev.falsegamemaster.ihatecores.api.ForgeRegistryMap;
import dev.falsegamemaster.ihatecores.registration.blocks.BlockWithCustomItem;
import dev.falsegamemaster.ihatecores.registration.blocks.IBlockColorWrapper;
import dev.falsegamemaster.ihatecores.registration.blocks.IDynamicColorBlock;
import dev.falsegamemaster.ihatecores.registration.items.ItemMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;

public class BlockMap
extends ForgeRegistryMap<Block> {
    private final ItemMap items;

    public BlockMap(ItemMap items) {
        super(Block.class);
        this.items = items;
    }

    public Block put(String name, Block block, @Nullable BlockItem blockItem, @Nullable IBlockColorWrapper color) {
        if (blockItem != null && this.isInsertable(name)) {
            this.items.put(name, blockItem, color);
        }
        return super.put(name, block);
    }

    @Override
    public Block put(String name, Block block) {
        BlockItem blockItem = BlockWithCustomItem.tryGetBlockItem(block).orElse(null);
        IBlockColorWrapper color = IDynamicColorBlock.tryGetColor(block).orElse(null);
        return this.put(name, block, blockItem, color);
    }

    public Block put(String name, Block block, Item.Properties properties) {
        IBlockColorWrapper color = IDynamicColorBlock.tryGetColor(block).orElse(null);
        return this.put(name, block, new BlockItem(block, properties), color);
    }

    public Block put(String name, Block block, IBlockColorWrapper color) {
        BlockItem blockItem = BlockWithCustomItem.tryGetBlockItem(block).orElse(null);
        return this.put(name, block, blockItem, color);
    }

    public Block put(String name, Block block, Item.Properties properties, IBlockColorWrapper color) {
        return this.put(name, block, new BlockItem(block, properties), color);
    }
}

