/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.block_entities;

import com.google.common.collect.ImmutableSet;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleBlockEntityType<T extends TileEntity>
extends TileEntityType<T> {
    protected final Supplier<? extends T> tile;
    protected final Set<Block> blocks;
    protected final ReverseTagWrapper<TileEntityType<?>> reverseTags = new ReverseTagWrapper((Object)this, () -> TagCollectionManager.func_242178_a().getCustomTypeCollection(ForgeRegistries.TILE_ENTITIES));

    public static <T extends TileEntity> TileEntityType<T> of(Function<TileEntityType<?>, ? extends T> tile, Block ... blocks) {
        return new SimpleBlockEntityType<T>(tile, (Set<Block>)ImmutableSet.copyOf((Object[])blocks));
    }

    public SimpleBlockEntityType(Function<TileEntityType<?>, ? extends T> tile, Set<Block> blocks) {
        super(() -> null, blocks, null);
        this.tile = () -> (TileEntity)tile.apply(this);
        this.blocks = blocks;
    }

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    public boolean isIn(ITag<TileEntityType<?>> tag) {
        return tag.func_230235_a_((Object)this);
    }

    @Nullable
    public T func_200968_a() {
        return (T)((TileEntity)this.tile.get());
    }

    public boolean func_223045_a(Block p_223045_1_) {
        return this.blocks.contains(p_223045_1_);
    }

    @Nullable
    public T func_226986_a_(IBlockReader reader, BlockPos pos) {
        TileEntity tile = reader.func_175625_s(pos);
        if (tile == null || tile.func_200662_C() != this) {
            return null;
        }
        return (T)((TileEntity)GenericsUtil.castOrNull(tile));
    }
}

