/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.block_entities;

import dev.falsegamemaster.ihatecores.registration.block_entities.IRecipeInventory;
import dev.falsegamemaster.ihatecores.registration.block_entities.InventoryBlockEntity;
import dev.falsegamemaster.ihatecores.registration.containers.IRecipeContainer;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.FakePlayerInventory;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.IHasDrops;
import dev.falsegamemaster.ihatecores.registration.recipes.CraftingResult;
import io.netty.buffer.Unpooled;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class RecipeBlockEntity<C extends Container, R extends IRecipe<?>>
extends InventoryBlockEntity<C>
implements IRecipeInventory<C, R>,
IRecipeHelperPopulator {
    protected final IRecipeType<?> recipeType;
    protected C container;

    protected RecipeBlockEntity(TileEntityType<?> tileType, ContainerType<?> containerType, IRecipeType<?> recipeType) {
        super(tileType, containerType);
        this.recipeType = recipeType;
    }

    protected C getContainer() {
        C container = this.container;
        if (container == null) {
            return this.createMenu(this.containerType, this.recipeType, -1, new FakePlayerInventory(), new PacketBuffer(Unpooled.buffer()));
        }
        return container;
    }

    @Override
    @Deprecated
    protected C createMenu(ContainerType<?> containerType, int id, PlayerInventory playerInv, PacketBuffer buf) {
        return this.createMenu(containerType, this.recipeType, id, playerInv, buf);
    }

    protected abstract C createMenu(ContainerType<?> var1, IRecipeType<?> var2, int var3, PlayerInventory var4, PacketBuffer var5);

    @Override
    protected void setupMenu(C container) {
        this.container = container;
    }

    @Override
    public boolean matchesRecipe(R recipe) {
        return ((IRecipeContainer)this.getContainer()).matchesRecipe(recipe);
    }

    @Override
    public ItemStack assembleRecipe(R recipe) {
        return ((IRecipeContainer)this.getContainer()).assembleRecipe(recipe);
    }

    protected <I extends IInventory> I getInventory() {
        return (I)this;
    }

    @Override
    public IRecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    @Override
    public CraftingResult craftRecipe() {
        if (this.field_145850_b == null) {
            return CraftingResult.failure();
        }
        return ((IRecipeContainer)this.getContainer()).craftRecipe();
    }

    public void func_194018_a(RecipeItemHelper helper) {
        this.items.forEach(arg_0 -> ((RecipeItemHelper)helper).func_194112_a(arg_0));
    }

    @Override
    public boolean shouldDropItem(IInventory inventory, ItemStack stack, int index) {
        C container = this.getContainer();
        if (0 <= index && index < ((Container)container).field_75151_b.size()) {
            return ((IHasDrops)container).shouldDropItem(inventory, stack, index);
        }
        return false;
    }
}

