/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.block_entities;

import dev.falsegamemaster.ihatecores.registration.containers.inventory.IHasDrops;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.IHasWorldPos;
import dev.falsegamemaster.ihatecores.registration.containers.inventory.IResizableInventory;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class InventoryBlockEntity<C extends Container>
extends LockableLootTileEntity
implements IResizableInventory,
IHasWorldPos,
IHasDrops {
    protected final ContainerType<?> containerType;
    protected NonNullList<ItemStack> items = NonNullList.func_191196_a();

    protected InventoryBlockEntity(TileEntityType<?> tileType, ContainerType<?> containerType) {
        super(tileType);
        this.containerType = containerType;
    }

    @Override
    public IWorldPosCallable getAccess() {
        if (this.field_145850_b == null) {
            return IWorldPosCallable.field_221489_a;
        }
        return IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Override
    @Deprecated
    public void setAccess(IWorldPosCallable access) {
    }

    public ItemStackHandler getItemHandler() {
        return new ItemStackHandler(this.items);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> items) {
        this.items = items;
    }

    @Override
    public void setSize(int size) {
        this.items = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInv) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        C container = this.createMenu(this.containerType, id, playerInv, buf);
        this.setupMenu(container);
        return container;
    }

    protected abstract C createMenu(ContainerType<?> var1, int var2, PlayerInventory var3, PacketBuffer var4);

    protected void setupMenu(C container) {
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    protected static NonNullList<ItemStack> loadAllItems(CompoundNBT nbt) {
        int size = nbt.func_74762_e("ContainerSize");
        NonNullList items = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        ListNBT list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compoundnbt = list.func_150305_b(i);
            int slot = compoundnbt.func_74762_e("Slot");
            if (0 > slot || slot >= size) continue;
            items.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
        return items;
    }

    protected static void saveAllItems(CompoundNBT nbt, NonNullList<ItemStack> items) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack itemstack = (ItemStack)items.get(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74768_a("Slot", i);
            itemstack.func_77955_b(compoundnbt);
            list.add((Object)compoundnbt);
        }
        nbt.func_74768_a("ContainerSize", items.size());
        nbt.func_218657_a("Items", (INBT)list);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (!this.func_184283_b(nbt)) {
            this.items = InventoryBlockEntity.loadAllItems(nbt);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.func_184282_c(nbt)) {
            InventoryBlockEntity.saveAllItems(nbt, this.func_190576_q());
        }
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b == null) {
            return;
        }
        InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (NonNullList)this.getDrops((IInventory)this));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this::getItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }
}

