/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration.block_entities;

import dev.falsegamemaster.ihatecores.api.ForgeRegistryMap;
import dev.falsegamemaster.ihatecores.registration.block_entities.IHasCustomTileRenderer;
import dev.falsegamemaster.ihatecores.registration.block_entities.SimpleBlockEntityType;
import dev.falsegamemaster.ihatecores.registration.blocks.BlockMap;
import dev.falsegamemaster.ihatecores.registration.containers.ContainerMap;
import dev.falsegamemaster.ihatecores.registration.recipes.RecipeMap;
import dev.falsegamemaster.ihatecores.util.data_structures.TriFunction;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class BlockEntityMap
extends ForgeRegistryMap<TileEntityType<?>> {
    protected final BlockMap blocks;
    protected final ContainerMap containers;
    protected final RecipeMap recipes;

    public BlockEntityMap(BlockMap blocks, ContainerMap containers, RecipeMap recipes) {
        super(TileEntityType.class);
        this.blocks = blocks;
        this.containers = containers;
        this.recipes = recipes;
    }

    @Override
    public TileEntityType<?> put(String name, TileEntityType<?> type) {
        this.tryBindRenderer(type);
        return super.put(name, type);
    }

    public <T extends TileEntity> void tryBindRenderer(TileEntityType<?> type) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            TileEntity blockEntity = type.func_200968_a();
            if (!(blockEntity instanceof IHasCustomTileRenderer)) {
                return;
            }
            Function<TileEntityRendererDispatcher, TileEntityRenderer> renderer = dispatcher -> ((IHasCustomTileRenderer)blockEntity).createRenderer(() -> dispatcher);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)type, renderer);
        });
    }

    protected Block[] getBlocks(String blockName, String ... blockNames) {
        Block[] blockArray = new Block[blockNames.length + 1];
        blockArray[0] = (Block)this.blocks.get(blockName);
        for (int i = 1; i < blockArray.length; ++i) {
            blockArray[i] = (Block)this.blocks.get(blockNames[i - 1]);
        }
        return blockArray;
    }

    protected Block[] getBlocks(List<String> blockNames) {
        Block[] blockArray = new Block[blockNames.size()];
        for (int i = 0; i < blockArray.length; ++i) {
            blockArray[i] = (Block)this.blocks.get(blockNames.get(i));
        }
        return blockArray;
    }

    public TileEntityType<?> put(String blockEntityName, Supplier<TileEntity> blockEntity, String blockName, String ... blockNames) {
        return this.put(blockEntityName, TileEntityType.Builder.func_223042_a(blockEntity, (Block[])this.getBlocks(blockName, blockNames)).func_206865_a(null));
    }

    public TileEntityType<?> put(String blockEntityName, Function<TileEntityType<?>, TileEntity> blockEntity, String blockName, String ... blockNames) {
        return this.put(blockEntityName, SimpleBlockEntityType.of(blockEntity, this.getBlocks(blockName, blockNames)));
    }

    public TileEntityType<?> put(String blockEntityName, String containerName, BiFunction<TileEntityType<?>, ContainerType<?>, TileEntity> blockEntity, String blockName, String ... blockNames) {
        return this.put(blockEntityName, (TileEntityType<?> blockEntityType) -> (TileEntity)blockEntity.apply((TileEntityType<?>)blockEntityType, (ContainerType<?>)this.containers.get(containerName)), blockName, blockNames);
    }

    public TileEntityType<?> put(String blockEntityName, String containerName, String recipeName, TriFunction<TileEntityType<?>, ContainerType<?>, IRecipeType<?>, TileEntity> blockEntity, String blockName, String ... blockNames) {
        return this.put(blockEntityName, (TileEntityType<?> tileType) -> (TileEntity)blockEntity.apply((TileEntityType<?>)tileType, (ContainerType<?>)this.containers.get(containerName), this.recipes.getType(recipeName)), blockName, blockNames);
    }

    @Override
    public TileEntityType<?> put(String name, BiFunction<TileEntityType<?>, ContainerType<?>, TileEntity> blockEntity) {
        return this.put(name, name, blockEntity, name, new String[0]);
    }

    @Override
    public TileEntityType<?> put(String name, TriFunction<TileEntityType<?>, ContainerType<?>, IRecipeType<?>, TileEntity> blockEntity) {
        return this.put(name, name, name, blockEntity, name, new String[0]);
    }

    public TileEntityType<?> put(String blockEntityName, Supplier<TileEntity> blockEntity, List<String> blockNames) {
        return this.put(blockEntityName, TileEntityType.Builder.func_223042_a(blockEntity, (Block[])this.getBlocks(blockNames)).func_206865_a(null));
    }

    public TileEntityType<?> put(String blockEntityName, Function<TileEntityType<?>, TileEntity> blockEntity, List<String> blockNames) {
        return this.put(blockEntityName, SimpleBlockEntityType.of(blockEntity, this.getBlocks(blockNames)));
    }

    public TileEntityType<?> put(String blockEntityName, String containerName, BiFunction<TileEntityType<?>, ContainerType<?>, TileEntity> blockEntity, List<String> blockNames) {
        return this.put(blockEntityName, (TileEntityType<?> blockEntityType) -> (TileEntity)blockEntity.apply((TileEntityType<?>)blockEntityType, (ContainerType<?>)this.containers.get(containerName)), blockNames);
    }

    public TileEntityType<?> put(String blockEntityName, String containerName, String recipeName, TriFunction<TileEntityType<?>, ContainerType<?>, IRecipeType<?>, TileEntity> blockEntity, List<String> blockNames) {
        return this.put(blockEntityName, (TileEntityType<?> tileType) -> (TileEntity)blockEntity.apply((TileEntityType<?>)tileType, (ContainerType<?>)this.containers.get(containerName), this.recipes.getType(recipeName)), blockNames);
    }
}

