/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration;

import dev.falsegamemaster.ihatecores.api.RegistryMap;
import dev.falsegamemaster.ihatecores.registration.blocks.BlockMap;
import dev.falsegamemaster.ihatecores.registration.items.ItemMap;
import dev.falsegamemaster.ihatecores.util.data_structures.ZippedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class RegistryCreators {
    protected final ZippedList<RegistryMap<?>, Runnable> creators = new ZippedList();
    protected List<Class<? extends RegistryMap<?>>> order;
    protected List<Integer> priorityQueue2 = new ArrayList<Integer>();
    protected List<Integer> standardQueue2 = new ArrayList<Integer>();

    public static List<Class<? extends RegistryMap<?>>> getDefaultOrder() {
        ArrayList order = new ArrayList();
        order.add(BlockMap.class);
        order.add(ItemMap.class);
        return order;
    }

    public RegistryCreators() {
        this(RegistryCreators.getDefaultOrder());
    }

    public RegistryCreators(List<Class<? extends RegistryMap<?>>> order) {
        this.setOrder(order);
    }

    protected void setupPriorityQueue() {
        this.priorityQueue2 = this.order.stream().map(c -> null).collect(Collectors.toList());
    }

    protected void cleanPriorityQueue() {
        this.priorityQueue2 = this.priorityQueue2.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @SafeVarargs
    public final RegistryCreators setOrder(Class<? extends RegistryMap<?>> ... order) {
        this.setOrder(Arrays.asList(order));
        return this;
    }

    public RegistryCreators setOrder(List<Class<? extends RegistryMap<?>>> order) {
        this.order = order;
        this.setupPriorityQueue();
        return this;
    }

    @SafeVarargs
    public final RegistryCreators mergeOrder(Class<? extends RegistryMap<?>> ... order) {
        this.mergeOrder(Arrays.asList(order));
        return this;
    }

    public RegistryCreators mergeOrder(List<Class<? extends RegistryMap<?>>> order) {
        this.order.addAll(order);
        this.setupPriorityQueue();
        return this;
    }

    public List<Class<? extends RegistryMap<?>>> getOrder() {
        return this.order;
    }

    public <T extends RegistryMap<?>> RegistryCreators add(T map, Consumer<T> creator) {
        int nextCreatorIndex = this.creators.size();
        boolean isPriority = false;
        for (int i = 0; i < this.order.size(); ++i) {
            if (this.order.get(i) != map.getClass()) continue;
            this.priorityQueue2.add(i, nextCreatorIndex);
            isPriority = true;
            break;
        }
        if (!isPriority) {
            this.standardQueue2.add(nextCreatorIndex);
        }
        this.creators.add(map, () -> creator.accept(map));
        return this;
    }

    protected void tryCreate(int index) {
        Runnable creator = this.creators.getValue((RegistryMap<?>)index);
        if (creator == null) {
            return;
        }
        creator.run();
    }

    public List<RegistryMap<?>> create() {
        this.cleanPriorityQueue();
        this.priorityQueue2.forEach(this::tryCreate);
        this.standardQueue2.forEach(this::tryCreate);
        return this.creators.getKeys();
    }
}

