/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration;

import dev.falsegamemaster.ihatecores.api.ForgeRegistryMap;
import dev.falsegamemaster.ihatecores.api.RegistryMap;
import dev.falsegamemaster.ihatecores.registration.IRegistrationListener;
import dev.falsegamemaster.ihatecores.registration.RegistryCreators;
import dev.falsegamemaster.ihatecores.registration.config.Config;
import dev.falsegamemaster.ihatecores.registration.config.ConfigMaps;
import dev.falsegamemaster.ihatecores.registration.events.InGameEventHandler;
import dev.falsegamemaster.ihatecores.registration.events.StartupEventHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Registration {
    public static void tryRegisterEventHandler(Object handler, IEventBus modBus, IEventBus forgeBus) {
        if (handler instanceof Class) {
            Class clazz = (Class)handler;
            if (StartupEventHandler.class.isAssignableFrom(clazz)) {
                modBus.register(handler);
            }
            if (InGameEventHandler.class.isAssignableFrom(clazz)) {
                forgeBus.register(handler);
            }
        } else {
            if (handler instanceof StartupEventHandler) {
                modBus.register(handler.getClass());
                modBus.register(handler);
            }
            if (handler instanceof InGameEventHandler) {
                forgeBus.register(handler.getClass());
                forgeBus.register(handler);
            }
        }
    }

    public static void registerConfig(String modid, String fileName, Config config, ModLoadingContext context) {
        context.registerConfig(config.getType(), config.build(), modid + "-" + fileName + ".toml");
    }

    public static void triggerRegistrationListener(String modid, String name, Object value) {
        if (value instanceof IRegistrationListener) {
            ((IRegistrationListener)value).onRegistration(new ResourceLocation(modid, name));
        }
    }

    public static void register(String modid, Iterable<RegistryMap<?>> maps, RegistryCreators creators, List<Object> eventHandlers, ConfigMaps configs) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext loadingContext = ModLoadingContext.get();
        configs.forEach((name, config) -> Registration.registerConfig(modid, name, config, loadingContext));
        creators.create();
        maps.forEach(map -> {
            try {
                Registration.tryRegisterEventHandler(map, modBus, forgeBus);
            }
            catch (Exception e) {
                throw new RuntimeException("MAP: " + map.getClass(), e);
            }
            RegisterInfo.of(modid, map).ifPresent(i -> {
                ((RegisterInfo)i).map.forEach((name, value) -> ((RegisterInfo)i).registrar.register(name, () -> value));
                ((RegisterInfo)i).registrar.register(modBus);
            });
            map.forEach((name, value) -> {
                try {
                    Registration.tryRegisterEventHandler(value, modBus, forgeBus);
                }
                catch (Exception e) {
                    throw new RuntimeException("MAP: " + map.getClass() + ", NAME: " + name + ", VALUE: " + value.getClass(), e);
                }
                Registration.triggerRegistrationListener(modid, name, value);
            });
        });
        eventHandlers.forEach(handler -> {
            try {
                Registration.tryRegisterEventHandler(handler, modBus, forgeBus);
            }
            catch (Exception e) {
                Class<?> handlerClass = handler instanceof Class ? (Class<?>)handler : handler.getClass();
                throw new RuntimeException("EVENT HANDLER: " + handlerClass, e);
            }
        });
    }

    private static class RegisterInfo<E extends IForgeRegistryEntry<E>> {
        private final ForgeRegistryMap<E> map;
        private final DeferredRegister<E> registrar;

        private static <E extends IForgeRegistryEntry<E>> Optional<RegisterInfo<E>> of(String modid, RegistryMap<?> map) {
            if (!(map instanceof ForgeRegistryMap)) {
                return Optional.empty();
            }
            ForgeRegistryMap forgeMap = (ForgeRegistryMap)map;
            return Optional.of(new RegisterInfo<E>(modid, forgeMap));
        }

        private RegisterInfo(String modid, ForgeRegistryMap<E> map) {
            this.map = map;
            this.registrar = DeferredRegister.create(this.map.registryClass(), (String)modid);
        }
    }
}

