/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.registration;

import dev.falsegamemaster.ihatecores.util.TypePreservingMap;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;

public abstract class LockableMap<K, V> {
    protected final TypePreservingMap<K, V> map = new TypePreservingMap();
    private boolean locked = false;

    public V put(K key, V value) {
        if (this.isInsertable(key)) {
            return this.map.put(key, value);
        }
        return value;
    }

    public <W extends V> W get(K key) {
        return this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public void lock() {
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isInsertable(K key) {
        return !this.locked && !this.map.containsKey(key);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.keySet().forEach((? super T key) -> action.accept((K)key, (V)this.map.get(key)));
    }
}

