/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.api;

import dev.falsegamemaster.ihatecores.registration.LockableMap;
import dev.falsegamemaster.ihatecores.util.GenericsUtil;
import dev.falsegamemaster.ihatecores.util.ResourceLocationUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public abstract class RegistryMap<E>
extends LockableMap<String, E> {
    protected static Map<Class<?>, Map<ResourceLocation, ?>> REGISTRY_MAPS = new HashMap();
    protected final Class<E> registryClass;
    protected String modid = null;

    protected static <E> Map<ResourceLocation, E> getMapForClass(Class<E> clazz) {
        return (Map)GenericsUtil.castOrNull(REGISTRY_MAPS.get(clazz));
    }

    public RegistryMap(Class<?> registryClass) {
        this.registryClass = (Class)GenericsUtil.castOrNull(registryClass);
        REGISTRY_MAPS.computeIfAbsent(this.registryClass, clazz -> new HashMap());
    }

    public Class<E> registryClass() {
        return this.registryClass;
    }

    protected ResourceLocation getResource(String name) {
        assert (this.modid != null);
        return new ResourceLocation(this.modid, name);
    }

    @Override
    public boolean isInsertable(String key) {
        Map<ResourceLocation, E> map = RegistryMap.getMapForClass(this.registryClass);
        return super.isInsertable(key) && !map.containsKey(ResourceLocationUtil.parse(this.modid, key));
    }

    @Override
    public E put(String name, E value) {
        if (this.isInsertable(name)) {
            Map<ResourceLocation, E> map1 = RegistryMap.getMapForClass(this.registryClass);
            map1.put(ResourceLocationUtil.parse(this.modid, name), value);
            return this.map.put(name, value);
        }
        return value;
    }

    @Override
    public <W extends E> W get(String key) {
        Object localValue = super.get(key);
        if (localValue != null) {
            return localValue;
        }
        return (W)GenericsUtil.castOrNull(RegistryMap.getMapForClass(this.registryClass).get(ResourceLocationUtil.parse(this.modid, key)));
    }

    public void setModId(@Nonnull String modid) {
        this.modid = modid;
    }

    public Optional<String> getModId() {
        return Optional.ofNullable(this.modid);
    }
}

