/*
 * Decompiled with CFR 0.152.
 */
package dev.falsegamemaster.ihatecores.api;

import dev.falsegamemaster.ihatecores.registration.Registration;
import dev.falsegamemaster.ihatecores.registration.RegistryCreators;
import dev.falsegamemaster.ihatecores.registration.RegistryMaps;
import dev.falsegamemaster.ihatecores.registration.config.ConfigMaps;
import dev.falsegamemaster.ihatecores.registration.events.EventHandlers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IHateCores {
    public static final Logger LOGGER = LogManager.getLogger();

    protected IHateCores(RegistryMaps maps, RegistryCreators creators, EventHandlers handlers, ConfigMaps configs) {
        this.register(maps, creators, handlers, configs);
    }

    protected IHateCores() {
        this.register(new RegistryMaps(), new RegistryCreators(), new EventHandlers(), new ConfigMaps());
    }

    protected void register(RegistryMaps maps, RegistryCreators creators, EventHandlers handlers, ConfigMaps configs) {
        String modid = this.getModId();
        this.registerConfigs(configs);
        this.buildConfigs();
        this.registerMaps(maps);
        maps.setModId(modid);
        this.populateMaps(creators);
        this.addEventHandlers(handlers);
        Registration.register(modid, maps, creators, handlers.get(), configs);
    }

    public abstract String getModId();

    public void addEventHandlers(EventHandlers handlers) {
    }

    public abstract void populateMaps(RegistryCreators var1);

    public abstract void registerMaps(RegistryMaps var1);

    public void buildConfigs() {
    }

    public void registerConfigs(ConfigMaps configs) {
    }
}

