/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.ghost;

import com.jozufozu.flywheel.util.VirtualEmptyModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.ghost.GhostBlockParams;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import org.lwjgl.system.MemoryStack;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer transparent = new TransparentGhostBlockRenderer();
    private static final GhostBlockRenderer standard = new DefaultGhostBlockRenderer();

    public static GhostBlockRenderer transparent() {
        return transparent;
    }

    public static GhostBlockRenderer standard() {
        return standard;
    }

    public abstract void render(MatrixStack var1, SuperRenderTypeBuffer var2, GhostBlockParams var3);

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(MatrixStack ms, SuperRenderTypeBuffer buffer, GhostBlockParams params) {
            ms.func_227860_a_();
            Minecraft mc = Minecraft.func_71410_x();
            BlockRendererDispatcher dispatcher = mc.func_175602_ab();
            IBakedModel model = dispatcher.func_184389_a(params.state);
            RenderType layer = RenderType.func_228645_f_();
            IVertexBuilder vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            ms.func_227861_a_(0.5, 0.5, 0.5);
            ms.func_227862_a_(0.85f, 0.85f, 0.85f);
            ms.func_227861_a_(-0.5, -0.5, -0.5);
            this.renderModel(params, ms.func_227866_c_(), vb, params.state, model, 1.0f, 1.0f, 1.0f, WorldRenderer.func_228421_a_((IBlockDisplayReader)mc.field_71441_e, (BlockPos)pos), OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }

        public void renderModel(GhostBlockParams params, MatrixStack.Entry entry, IVertexBuilder vb, @Nullable BlockState state, IBakedModel model, float p_228804_5_, float p_228804_6_, float p_228804_7_, int p_228804_8_, int p_228804_9_, IModelData modelData) {
            Random random = new Random();
            for (Direction direction : Direction.values()) {
                random.setSeed(42L);
                TransparentGhostBlockRenderer.renderQuad(params, entry, vb, p_228804_5_, p_228804_6_, p_228804_7_, model.getQuads(state, direction, random, modelData), p_228804_8_, p_228804_9_);
            }
            random.setSeed(42L);
            TransparentGhostBlockRenderer.renderQuad(params, entry, vb, p_228804_5_, p_228804_6_, p_228804_7_, model.getQuads(state, (Direction)null, random, modelData), p_228804_8_, p_228804_9_);
        }

        private static void renderQuad(GhostBlockParams params, MatrixStack.Entry p_228803_0_, IVertexBuilder p_228803_1_, float p_228803_2_, float p_228803_3_, float p_228803_4_, List<BakedQuad> p_228803_5_, int p_228803_6_, int p_228803_7_) {
            Float alpha = Float.valueOf(params.alphaSupplier.get().floatValue() * 0.75f * PlacementHelpers.getCurrentAlpha());
            for (BakedQuad bakedquad : p_228803_5_) {
                float f2;
                float f1;
                float f;
                if (bakedquad.func_178212_b()) {
                    f = MathHelper.func_76131_a((float)p_228803_2_, (float)0.0f, (float)1.0f);
                    f1 = MathHelper.func_76131_a((float)p_228803_3_, (float)0.0f, (float)1.0f);
                    f2 = MathHelper.func_76131_a((float)p_228803_4_, (float)0.0f, (float)1.0f);
                } else {
                    f = 1.0f;
                    f1 = 1.0f;
                    f2 = 1.0f;
                }
                TransparentGhostBlockRenderer.quad(alpha.floatValue(), p_228803_1_, p_228803_0_, bakedquad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, f, f1, f2, new int[]{p_228803_6_, p_228803_6_, p_228803_6_, p_228803_6_}, p_228803_7_);
            }
        }

        static void quad(float alpha, IVertexBuilder vb, MatrixStack.Entry p_227890_1_, BakedQuad p_227890_2_, float[] p_227890_3_, float p_227890_4_, float p_227890_5_, float p_227890_6_, int[] p_227890_7_, int p_227890_8_) {
            int[] aint = p_227890_2_.func_178209_a();
            Vector3i Vector3i2 = p_227890_2_.func_178210_d().func_176730_m();
            Vector3f vector3f = new Vector3f((float)Vector3i2.func_177958_n(), (float)Vector3i2.func_177956_o(), (float)Vector3i2.func_177952_p());
            Matrix4f matrix4f = p_227890_1_.func_227870_a_();
            vector3f.func_229188_a_(p_227890_1_.func_227872_b_());
            int vertexSize = DefaultVertexFormats.field_176600_a.func_181719_f();
            int j = aint.length / vertexSize;
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormats.field_176600_a.func_177338_f());
                IntBuffer intbuffer = bytebuffer.asIntBuffer();
                for (int k = 0; k < j; ++k) {
                    ((Buffer)intbuffer).clear();
                    intbuffer.put(aint, k * vertexSize, vertexSize);
                    float f = bytebuffer.getFloat(0);
                    float f1 = bytebuffer.getFloat(4);
                    float f2 = bytebuffer.getFloat(8);
                    float r = p_227890_3_[k] * p_227890_4_;
                    float g = p_227890_3_[k] * p_227890_5_;
                    float b = p_227890_3_[k] * p_227890_6_;
                    int l = vb.applyBakedLighting(p_227890_7_[k], bytebuffer);
                    float f9 = bytebuffer.getFloat(16);
                    float f10 = bytebuffer.getFloat(20);
                    Vector4f vector4f = new Vector4f(f, f1, f2, 1.0f);
                    vector4f.func_229372_a_(matrix4f);
                    vb.applyBakedNormals(vector3f, bytebuffer, p_227890_1_.func_227872_b_());
                    vb.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), r, g, b, alpha, f9, f10, p_227890_8_, l, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
                }
            }
        }
    }

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(MatrixStack ms, SuperRenderTypeBuffer buffer, GhostBlockParams params) {
            ms.func_227860_a_();
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel model = dispatcher.func_184389_a(params.state);
            RenderType layer = RenderTypeLookup.func_239220_a_((BlockState)params.state, (boolean)false);
            IVertexBuilder vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            dispatcher.func_175019_b().renderModel(ms.func_227866_c_(), vb, params.state, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
    }
}

