/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.BoxElement;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.ElementWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.content.PonderTagScreen;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class PonderTagIndexScreen
extends NavigatableSimiScreen {
    public static final String EXIT = "ponder.exit";
    public static final String TITLE = "ponder.index_title";
    public static final String WELCOME = "ponder.welcome";
    public static final String CATEGORIES = "ponder.categories";
    public static final String DESCRIPTION = "ponder.index_description";
    private final double itemXmult = 0.5;
    protected Rectangle2d itemArea;
    protected Rectangle2d chapterArea;
    private final double mainYmult = 0.15;
    private PonderTag hoveredItem = null;

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        super.func_231160_c_();
        List<PonderTag> tags = PonderRegistry.TAGS.getListedTags();
        int rowCount = MathHelper.func_76125_a((int)((int)Math.ceil((double)tags.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(tags.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.field_230708_k_ * 0.5);
        int itemCenterY = this.getItemsY();
        for (PonderTag i : tags) {
            PonderButton b = (PonderButton)((Object)((AbstractSimiWidget)((Object)new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showingTag(i))).withCallback((mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(new PonderTagScreen(i));
            }));
            this.widgets.add(b);
            layout.next();
        }
        this.backTrack = (PonderButton)((Object)((AbstractSimiWidget)((Object)((ElementWidget)((Object)new PonderButton(31, this.field_230709_l_ - 31 - 20).enableFade(0, 5))).showing(AllIcons.I_MTD_CLOSE))).withCallback(() -> ScreenOpener.openPreviousScreen(this, Optional.empty())));
        this.widgets.add(this.backTrack);
        this.backTrack.fade(1.0f);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = null;
        MainWindow w = this.field_230706_i_.func_228018_at_();
        double mouseX = this.field_230706_i_.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.field_230706_i_.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        for (Widget widget : this.widgets) {
            if (widget == this.backTrack || !(widget instanceof PonderButton) || !widget.func_231047_b_(mouseX, mouseY)) continue;
            this.hoveredItem = ((PonderButton)widget).getTag();
        }
    }

    @Override
    protected String backTrackingLangKey() {
        return EXIT;
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.renderItems(ms, mouseX, mouseY, partialTicks);
        ms.func_227860_a_();
        ms.func_227861_a_((double)(this.field_230708_k_ / 2 - 120), (double)this.field_230709_l_ * 0.15 - 40.0, 0.0);
        ms.func_227860_a_();
        int x = 59;
        int y = 31;
        String title = Lang.translate(WELCOME, new Object[0]).getString();
        int streakHeight = 35;
        UIRenderHelper.streak(ms, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(21.0f, 21.0f, 100.0f)).withBounds(30, 30)).render(ms);
        this.field_230712_o_.func_238421_b_(ms, title, (float)(x + 8), (float)(y + 1), Theme.i(Theme.Key.TEXT));
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227861_a_(23.0, 23.0, 10.0);
        ms.func_227862_a_(1.66f, 1.66f, 1.66f);
        ms.func_227861_a_(-4.0, -4.0, 0.0);
        ms.func_227862_a_(1.5f, 1.5f, 1.5f);
        GuiGameElement.of(AllItems.WRENCH.asStack()).render(ms);
        ms.func_227865_b_();
        ms.func_227865_b_();
        ms.func_227860_a_();
        int w = (int)((double)this.field_230708_k_ * 0.45);
        x = (this.field_230708_k_ - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.func_199317_d(), 48);
        String desc = Lang.translate(DESCRIPTION, new Object[0]).getString();
        int h = this.field_230712_o_.func_78267_b(desc, w);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(x - 3, y - 3, 90.0f)).withBounds(w + 6, h + 6)).render(ms);
        ms.func_227861_a_(0.0, 0.0, 100.0);
        FontHelper.drawSplitString(ms, this.field_230712_o_, desc, x, y, w, Theme.i(Theme.Key.TEXT));
        ms.func_227865_b_();
    }

    protected void renderItems(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        List<PonderTag> tags = PonderRegistry.TAGS.getListedTags();
        if (tags.isEmpty()) {
            return;
        }
        int x = (int)((double)this.field_230708_k_ * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Lang.translate(CATEGORIES, new Object[0]).getString();
        int stringWidth = this.field_230712_o_.func_78256_a(relatedTitle);
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at((float)(this.windowWidth - stringWidth) / 2.0f - 5.0f, this.itemArea.func_199319_b() - 21, 100.0f)).withBounds(stringWidth + 10, 10)).render(ms);
        ms.func_227861_a_(0.0, 0.0, 200.0);
        PonderTagIndexScreen.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (String)relatedTitle, (int)(this.windowWidth / 2), (int)(this.itemArea.func_199319_b() - 20), (int)Theme.i(Theme.Key.TEXT));
        ms.func_227861_a_(0.0, 0.0, -200.0);
        UIRenderHelper.streak(ms, 0.0f, 0, 0, this.itemArea.func_199317_d() + 10, this.itemArea.func_199316_c() / 2 + 75);
        UIRenderHelper.streak(ms, 180.0f, 0, 0, this.itemArea.func_199317_d() + 10, this.itemArea.func_199316_c() / 2 + 75);
        ms.func_227865_b_();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.field_230709_l_ + 85.0);
    }

    @Override
    protected void renderWindowForeground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        ms.func_227860_a_();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        ms.func_227861_a_(0.0, 0.0, 200.0);
        if (this.hoveredItem != null) {
            List<ITextComponent> list = TooltipHelper.cutStringTextComponent(this.hoveredItem.getDescription(), TextFormatting.GRAY, TextFormatting.GRAY);
            list.add(0, (ITextComponent)new StringTextComponent(this.hoveredItem.getTitle()));
            this.func_243308_b(ms, list, mouseX, mouseY);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
        ms.func_227865_b_();
    }

    @Override
    protected String getBreadcrumbTitle() {
        return Lang.translate(TITLE, new Object[0]).getString();
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.hoveredItem = null;
    }
}

