/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public abstract class AbstractSimiContainerScreen<T extends Container>
extends ContainerScreen<T> {
    protected List<Widget> widgets = new ArrayList<Widget>();
    protected int windowXOffset;
    protected int windowYOffset;

    public AbstractSimiContainerScreen(T container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    protected void setWindowSize(int width, int height) {
        this.field_146999_f = width;
        this.field_147000_g = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_147003_i += this.windowXOffset;
        this.field_147009_r += this.windowYOffset;
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        partialTicks = Minecraft.func_71410_x().func_184121_ak();
        this.func_230446_a_(matrixStack);
        this.renderWindow(matrixStack, mouseX, mouseY, partialTicks);
        for (Widget widget : this.widgets) {
            widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        this.renderWindowForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.func_231044_a_(x, y, button)) continue;
            result = true;
        }
        return result || super.func_231044_a_(x, y, button);
    }

    public boolean func_231046_a_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        for (Widget widget : this.widgets) {
            if (!widget.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        if (super.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)code, (int)p_keyPressed_2_);
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char character, int code) {
        for (Widget widget : this.widgets) {
            if (!widget.func_231042_a_(character, code)) continue;
            return true;
        }
        return super.func_231042_a_(character, code);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        for (Widget widget : this.widgets) {
            if (!widget.func_231043_a_(mouseX, mouseY, delta)) continue;
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.func_231048_c_(x, y, button)) continue;
            result = true;
        }
        return result | super.func_231048_c_(x, y, button);
    }

    protected abstract void renderWindow(MatrixStack var1, int var2, int var3, float var4);

    protected void func_230450_a_(MatrixStack p_230450_1_, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
    }

    protected void renderWindowForeground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        for (Widget widget : this.widgets) {
            if (!widget.func_230449_g_()) continue;
            if (widget instanceof AbstractSimiWidget) {
                if (((AbstractSimiWidget)widget).getToolTip().isEmpty()) continue;
                this.func_243308_b(matrixStack, ((AbstractSimiWidget)widget).getToolTip(), mouseX, mouseY);
                continue;
            }
            widget.func_230443_a_(matrixStack, mouseX, mouseY);
        }
    }

    public double getItemCountTextScale() {
        int guiScaleFactor = (int)this.field_230706_i_.func_228018_at_().func_198100_s();
        double scale = 1.0;
        switch (guiScaleFactor) {
            case 1: {
                scale = 1.005859375;
                break;
            }
            case 2: {
                scale = 0.5;
                break;
            }
            case 3: {
                scale = 0.675;
                break;
            }
            case 4: {
                scale = 0.75;
                break;
            }
            default: {
                scale = ((float)guiScaleFactor - 1.0f) / (float)guiScaleFactor;
            }
        }
        return scale;
    }

    public int getLeftOfCentered(int textureWidth) {
        return (this.field_230708_k_ - textureWidth) / 2;
    }

    public void renderPlayerInventory(MatrixStack ms, int x, int y) {
        AllGuiTextures.PLAYER_INVENTORY.draw(ms, (AbstractGui)this, x, y);
        this.field_230712_o_.func_243248_b(ms, this.field_213127_e.func_145748_c_(), (float)(x + 8), (float)(y + 6), 0x404040);
    }

    public List<Rectangle2d> getExtraAreas() {
        return Collections.emptyList();
    }

    @Deprecated
    protected void renderItemOverlayIntoGUI(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int textColor) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                this.draw(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.draw(bufferbuilder, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
            }
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                matrixStack.func_227860_a_();
                int guiScaleFactor = (int)this.field_230706_i_.func_228018_at_().func_198100_s();
                matrixStack.func_227861_a_((double)((float)xPosition + 16.5f), (double)((float)yPosition + 16.5f), 0.0);
                double scale = this.getItemCountTextScale();
                matrixStack.func_227862_a_((float)scale, (float)scale, 0.0f);
                double d = (float)(-fr.func_78256_a(s)) - (guiScaleFactor > 1 ? 0.0f : -0.5f);
                this.field_230712_o_.getClass();
                matrixStack.func_227861_a_(d, (double)((float)(-9) + (guiScaleFactor > 1 ? 1.0f : 1.75f)), 0.0);
                fr.func_238405_a_(matrixStack, s, 0.0f, 0.0f, textColor);
                matrixStack.func_227865_b_();
                RenderSystem.enableBlend();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
            }
        }
    }

    @Deprecated
    private void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_((double)(x + 0), (double)(y + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + 0), (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)(y + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Deprecated
    protected void debugWindowArea(MatrixStack matrixStack) {
        AbstractSimiContainerScreen.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + this.field_146999_f), (int)(this.field_147009_r + this.field_147000_g), (int)this.field_147003_i, (int)this.field_147009_r, (int)-741092397);
    }

    @Deprecated
    protected void debugExtraAreas(MatrixStack matrixStack) {
        for (Rectangle2d area : this.getExtraAreas()) {
            AbstractSimiContainerScreen.func_238467_a_((MatrixStack)matrixStack, (int)(area.func_199318_a() + area.func_199316_c()), (int)(area.func_199319_b() + area.func_199317_d()), (int)area.func_199318_a(), (int)area.func_199319_b(), (int)-741092397);
        }
    }
}

