/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.google.common.collect.Maps;
import com.simibubi.create.Create;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CriterionTriggerBase<T extends Instance>
implements ICriterionTrigger<T> {
    private final ResourceLocation id;
    protected final Map<PlayerAdvancements, Set<ICriterionTrigger.Listener<T>>> listeners = Maps.newHashMap();

    public CriterionTriggerBase(String id) {
        this.id = Create.asResource(id);
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Set playerListeners = this.listeners.computeIfAbsent(playerAdvancementsIn, k -> new HashSet());
        playerListeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Set<ICriterionTrigger.Listener<T>> playerListeners = this.listeners.get(playerAdvancementsIn);
        if (playerListeners != null) {
            playerListeners.remove(listener);
            if (playerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    protected void trigger(ServerPlayerEntity player, @Nullable List<Supplier<Object>> suppliers) {
        PlayerAdvancements playerAdvancements = player.func_192039_O();
        Set<ICriterionTrigger.Listener<T>> playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners != null) {
            LinkedList<ICriterionTrigger.Listener<T>> list = new LinkedList<ICriterionTrigger.Listener<T>>();
            for (ICriterionTrigger.Listener<T> listener2 : playerListeners) {
                if (!((Instance)listener2.func_192158_a()).test(suppliers)) continue;
                list.add(listener2);
            }
            list.forEach(listener -> listener.func_192159_a(playerAdvancements));
        }
    }

    public static abstract class Instance
    extends CriterionInstance {
        public Instance(ResourceLocation idIn, EntityPredicate.AndPredicate p_i231464_2_) {
            super(idIn, p_i231464_2_);
        }

        protected abstract boolean test(@Nullable List<Supplier<Object>> var1);
    }
}

