/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.logistics.item.LecternControllerBlock;
import com.simibubi.create.content.logistics.item.LinkedControllerBindPacket;
import com.simibubi.create.content.logistics.item.LinkedControllerInputPacket;
import com.simibubi.create.content.logistics.item.LinkedControllerItemRenderer;
import com.simibubi.create.content.logistics.item.LinkedControllerStopLecternPacket;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;

public class LinkedControllerClientHandler {
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    private static BlockPos lecternPos;
    private static BlockPos selectedLocation;
    private static Vector<KeyBinding> controls;
    private static int packetCooldown;

    public static Vector<KeyBinding> getControls() {
        if (controls == null) {
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            controls = new Vector(6);
            controls.add(gameSettings.field_74351_w);
            controls.add(gameSettings.field_74368_y);
            controls.add(gameSettings.field_74370_x);
            controls.add(gameSettings.field_74366_z);
            controls.add(gameSettings.field_74314_A);
            controls.add(gameSettings.field_228046_af_);
        }
        return controls;
    }

    public static void toggleBindMode(BlockPos location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static void toggle() {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = null;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static void activateInLectern(BlockPos lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = lecternAt;
        }
    }

    public static void deactivateInLectern() {
        if (MODE == Mode.ACTIVE && LinkedControllerClientHandler.inLectern()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static boolean inLectern() {
        return lecternPos != null;
    }

    protected static void onReset() {
        LinkedControllerClientHandler.getControls().forEach(kb -> kb.func_225593_a_(LinkedControllerClientHandler.isActuallyPressed(kb)));
        packetCooldown = 0;
        selectedLocation = BlockPos.field_177992_a;
        if (LinkedControllerClientHandler.inLectern()) {
            AllPackets.channel.sendToServer((Object)new LinkedControllerStopLecternPacket(lecternPos));
        }
        lecternPos = null;
        if (!currentlyPressed.isEmpty()) {
            AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(currentlyPressed, false));
        }
        currentlyPressed.clear();
        LinkedControllerItemRenderer.resetButtons();
    }

    protected static boolean isActuallyPressed(KeyBinding kb) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)kb.getKey().func_197937_c());
    }

    public static void tick() {
        LinkedControllerItemRenderer.tick();
        if (MODE == Mode.IDLE) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack heldItem = player.func_184614_ca();
        if (player.func_175149_v()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (!(LinkedControllerClientHandler.inLectern() || AllItems.LINKED_CONTROLLER.isIn(heldItem) || AllItems.LINKED_CONTROLLER.isIn(heldItem = player.func_184592_cb()))) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (LinkedControllerClientHandler.inLectern() && ((LecternControllerBlock)AllBlocks.LECTERN_CONTROLLER.get()).getTileEntityOptional((IBlockReader)mc.field_71441_e, lecternPos).map(te -> !te.isUsedBy((PlayerEntity)mc.field_71439_g)).orElse(true).booleanValue()) {
            LinkedControllerClientHandler.deactivateInLectern();
            return;
        }
        if (mc.field_71462_r != null) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (InputMappings.func_216506_a((long)mc.func_228018_at_().func_198092_i(), (int)256)) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        Vector<KeyBinding> controls = LinkedControllerClientHandler.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!LinkedControllerClientHandler.isActuallyPressed(controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (MODE == Mode.ACTIVE) {
            if (!releasedKeys.isEmpty()) {
                AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(releasedKeys, false, lecternPos));
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.field_70170_p, player.func_233580_cy_(), 1.0f, 0.5f, true);
            }
            if (!newKeys.isEmpty()) {
                AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(newKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.field_70170_p, player.func_233580_cy_(), 1.0f, 0.75f, true);
            }
            if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
                AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(pressedKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
            }
        }
        if (MODE == Mode.BIND) {
            Iterator iterator;
            VoxelShape shape = mc.field_71441_e.func_180495_p(selectedLocation).func_196954_c((IBlockReader)mc.field_71441_e, selectedLocation);
            if (!shape.func_197766_b()) {
                CreateClient.OUTLINER.showAABB("controller", shape.func_197752_a().func_186670_a(selectedLocation)).colored(12008493).lineWidth(0.0625f);
            }
            if ((iterator = newKeys.iterator()).hasNext()) {
                Integer integer = (Integer)iterator.next();
                LinkBehaviour linkBehaviour = TileEntityBehaviour.get((IBlockReader)mc.field_71441_e, selectedLocation, LinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    AllPackets.channel.sendToServer((Object)new LinkedControllerBindPacket(integer, selectedLocation));
                    Lang.sendStatus((PlayerEntity)mc.field_71439_g, "linked_controller.key_bound", controls.get(integer).func_238171_j_().getString());
                }
                MODE = Mode.IDLE;
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.func_225593_a_(false));
    }

    public static void renderOverlay(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, float partialTicks) {
        if (MODE != Mode.BIND) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ms.func_227860_a_();
        GoggleOverlayRenderer.TooltipScreen tooltipScreen = new GoggleOverlayRenderer.TooltipScreen(null);
        tooltipScreen.func_231158_b_(mc, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p());
        Object[] keys = new Object[6];
        Vector<KeyBinding> controls = LinkedControllerClientHandler.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            KeyBinding keyBinding = controls.get(i);
            keys[i] = keyBinding.func_238171_j_().getString();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Lang.createTranslationTextComponent("linked_controller.bind_mode", new Object[0]).func_240699_a_(TextFormatting.GOLD));
        list.addAll(TooltipHelper.cutTextComponent((ITextComponent)Lang.createTranslationTextComponent("linked_controller.press_keybind", keys), TextFormatting.GRAY, TextFormatting.GRAY));
        int width = 0;
        int n = list.size();
        mc.field_71466_p.getClass();
        int height = n * 9;
        for (ITextComponent iTextComponent : list) {
            width = Math.max(width, mc.field_71466_p.func_238414_a_((ITextProperties)iTextComponent));
        }
        int x = tooltipScreen.field_230708_k_ / 3 - width / 2;
        int n2 = tooltipScreen.field_230709_l_ - height;
        tooltipScreen.func_243308_b(ms, list, x, n2);
        ms.func_227865_b_();
    }

    static {
        selectedLocation = BlockPos.field_177992_a;
    }

    public static enum Mode {
        IDLE,
        ACTIVE,
        BIND;

    }
}

